/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.carol.cmi.compiler;

import java.lang.reflect.Method;
import java.util.ArrayList;
import org.objectweb.carol.cmi.compiler.CompilerException;

public class MethodProto {
    private String methodName;
    private String returnType;
    private String[] paramTypes;
    private int hash;

    public MethodProto(String sign) throws CompilerException {
        int mns;
        int obr = sign.indexOf(40);
        if (obr < 0) {
            this.badSignature(sign);
        }
        if ((mns = sign.lastIndexOf(32, obr)) < 0) {
            this.badSignature(sign);
        }
        this.methodName = sign.substring(mns + 1, obr);
        int mnd = this.methodName.lastIndexOf(46);
        if (mnd >= 0) {
            this.methodName = this.methodName.substring(mnd + 1);
        }
        while (sign.charAt(mns - 1) == ' ') {
            --mns;
        }
        int rts = sign.lastIndexOf(32, mns - 1);
        this.returnType = sign.substring(rts + 1, mns);
        int cbr = sign.indexOf(41);
        String params = sign.substring(obr + 1, cbr);
        ArrayList<String> p = new ArrayList<String>();
        params = params.trim();
        while (!"".equals(params)) {
            String param;
            int com = params.indexOf(44);
            if (com < 0) {
                param = params;
                params = "";
            } else {
                param = params.substring(0, com);
                params = params.substring(com + 1);
            }
            int te = param.indexOf(32);
            if (te > 0) {
                param = param.substring(0, te);
                p.add(param);
            } else if (te < 0) {
                p.add(param);
            }
            params = params.trim();
        }
        this.paramTypes = new String[p.size()];
        p.toArray(this.paramTypes);
        this.doHash();
    }

    public MethodProto(Method m) {
        this.returnType = m.getReturnType().getName();
        this.methodName = m.getName();
        Class<?>[] params = m.getParameterTypes();
        this.paramTypes = new String[params.length];
        int i = 0;
        while (i < params.length) {
            this.paramTypes[i] = params[i].getName();
            ++i;
        }
        this.doHash();
    }

    private void doHash() {
        this.hash = this.returnType.hashCode() + this.methodName.hashCode();
        int i = 0;
        while (i < this.paramTypes.length) {
            this.hash += this.paramTypes[i].hashCode();
            ++i;
        }
    }

    private void badSignature(String sign) throws CompilerException {
        throw new CompilerException("Bad method signature : " + sign);
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MethodProto) {
            MethodProto mp = (MethodProto)obj;
            String[] pt = mp.paramTypes;
            if (this.methodName.equals(mp.methodName) && this.paramTypes.length == pt.length && this.returnType.equals(mp.returnType)) {
                int i = 0;
                while (i < this.paramTypes.length) {
                    if (!this.paramTypes[i].equals(pt[i])) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        }
        return false;
    }

    public String toString() {
        String s = this.returnType + " " + this.methodName + "(";
        int i = 0;
        while (i < this.paramTypes.length) {
            if (i != 0) {
                s = s + ",";
            }
            s = s + this.paramTypes[i];
            ++i;
        }
        return s + ")";
    }
}

