/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.carol.cmi;

import java.rmi.AlreadyBoundException;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.HashSet;
import org.objectweb.carol.cmi.ClusterRegistry;
import org.objectweb.carol.cmi.ClusterStub;
import org.objectweb.carol.cmi.ClusterStubData;
import org.objectweb.carol.cmi.StubLB;
import org.objectweb.carol.cmi.StubLBFilter;

public class ClusterRegistryImpl_Cluster
implements ClusterStub,
ClusterRegistry {
    private ClusterStubData csd;
    private StubLB lb;

    public ClusterRegistryImpl_Cluster(ClusterStubData csd) throws RemoteException {
        this.csd = csd;
        this.lb = csd.getRandom();
    }

    private void setLB() {
        if (this.lb == null) {
            this.lb = this.csd.getRandom();
        }
    }

    public String[] list() throws RemoteException {
        this.setLB();
        ClusterRegistry stub = (ClusterRegistry)this.lb.get();
        HashSet filter = null;
        while (true) {
            try {
                String[] result = stub.list();
                return result;
            }
            catch (RemoteException e) {
                if (!(e instanceof ConnectException) && !(e instanceof ConnectIOException)) {
                    throw e;
                }
                if (this.csd.isStubDebug()) {
                    this.csd.debug("Connection to registry refused, retry");
                }
                if (filter == null) {
                    filter = new StubLBFilter();
                }
                filter.add(stub);
                stub = (ClusterRegistry)this.lb.get((StubLBFilter)filter);
                continue;
            }
            break;
        }
    }

    public void test() throws RemoteException {
        this.setLB();
        ClusterRegistry stub = (ClusterRegistry)this.lb.get();
        HashSet filter = null;
        while (true) {
            try {
                stub.test();
                continue;
            }
            catch (RemoteException e) {
                if (!(e instanceof ConnectException) && !(e instanceof ConnectIOException)) {
                    throw e;
                }
                if (this.csd.isStubDebug()) {
                    this.csd.debug("Connection to registry refused, retry");
                }
                if (filter == null) {
                    filter = new StubLBFilter();
                }
                filter.add(stub);
                stub = (ClusterRegistry)this.lb.get((StubLBFilter)filter);
                continue;
            }
            break;
        }
    }

    public Remote lookup(String name) throws NotBoundException, RemoteException {
        this.setLB();
        ClusterRegistry stub = (ClusterRegistry)this.lb.get();
        HashSet filter = null;
        while (true) {
            try {
                Remote result = stub.lookup(name);
                return result;
            }
            catch (RemoteException e) {
                if (!(e instanceof ConnectException) && !(e instanceof ConnectIOException)) {
                    throw e;
                }
                if (this.csd.isStubDebug()) {
                    this.csd.debug("Connection to registry refused, retry");
                }
                if (filter == null) {
                    filter = new StubLBFilter();
                }
                filter.add(stub);
                stub = (ClusterRegistry)this.lb.get((StubLBFilter)filter);
                continue;
            }
            break;
        }
    }

    public void bind(String name, Remote obj) throws AlreadyBoundException, RemoteException {
        throw new RemoteException("Can't bind into multiple servers");
    }

    public void rebind(String name, Remote obj) throws RemoteException {
        throw new RemoteException("Can't rebind into multiple servers");
    }

    public void unbind(String name) throws NotBoundException, RemoteException {
        throw new RemoteException("Can't unbind from multiple servers");
    }
}

