/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jotm;

import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.objectweb.jonas_timer.TraceTimer;
import org.objectweb.jotm.Jotm;
import org.objectweb.transaction.jta.TMService;

public class Main
extends Thread {
    private static final String progname = "JOTM";
    private static Options cmdLineOptions = null;
    static boolean verbose = false;
    static boolean debug = false;
    static int timeout = 0;
    static boolean remote = false;
    static String userTransactionName = null;
    static String transactionManagerName = null;
    static Context ictx = null;
    static PrintWriter logWriter = new PrintWriter(System.out, true);
    private static TMService jotm;

    public void run() {
        System.out.print("shutting down...");
        try {
            ictx.unbind(userTransactionName);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            ictx.unbind(transactionManagerName);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            jotm.stop();
        }
        catch (Exception e) {
            // empty catch block
        }
        logWriter.close();
    }

    public static void printHelp(Options cmdLineOptions) {
        HelpFormatter hf = new HelpFormatter();
        hf.printHelp("JOTM [options...]", cmdLineOptions);
    }

    private static void verbose(String msg) {
        if (verbose) {
            System.out.println(msg);
        }
    }

    private static void checkRegistryMessage() {
        System.err.println("Current JNDI settings are:");
        boolean found = false;
        try {
            Hashtable<?, ?> env = ictx.getEnvironment();
            Enumeration<?> e = env.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                System.err.println("- " + key + "=" + env.get(key));
                found = true;
            }
        }
        catch (NamingException e) {
            // empty catch block
        }
        if (!found) {
            System.err.println("JNDI properties are not set!");
        } else {
            System.err.println("Check that registry is running on a port matching JNDI properties");
        }
    }

    public static void main(String[] args) {
        cmdLineOptions = new Options();
        cmdLineOptions.addOption('d', "debug", false, "debug mode", false, false);
        cmdLineOptions.addOption('v', "verbose", false, "verbose mode", false, false);
        cmdLineOptions.addOption('h', "help", false, "print this message and exit", false, false);
        cmdLineOptions.addOption('m', "transaction_manager", true, "JNDI URL of the TransactionManager", false, false);
        cmdLineOptions.addOption('r', "remote", false, "lookup remote transaction factory", false, false);
        cmdLineOptions.addOption('t', "timeout", true, "default transaction timeout (in seconds)", false, false);
        cmdLineOptions.addOption('u', "user_transaction", true, "JNDI URL of the UserTransaction", false, false);
        CommandLine cmd = null;
        try {
            cmd = cmdLineOptions.parse(args, true);
        }
        catch (ParseException e) {
            System.err.println("\n" + e.getMessage());
            Main.printHelp(cmdLineOptions);
            System.err.println();
            System.exit(1);
        }
        debug = cmd.hasOption('d');
        remote = cmd.hasOption('r');
        verbose = cmd.hasOption('v');
        if (cmd.hasOption('h')) {
            Main.printHelp(cmdLineOptions);
            System.exit(1);
        }
        if (cmd.hasOption('m')) {
            transactionManagerName = cmd.getOptionValue('m');
        }
        if (cmd.hasOption('t')) {
            try {
                timeout = Integer.parseInt(cmd.getOptionValue('t'));
            }
            catch (NumberFormatException e) {
                System.err.println("\ntimeout is not a number");
                Main.printHelp(cmdLineOptions);
                System.err.println();
                System.exit(1);
            }
        }
        if (cmd.hasOption('u')) {
            userTransactionName = cmd.getOptionValue('u');
        }
        Main.verbose("UserTransaction Name =" + userTransactionName);
        Main.verbose("TransactionManager Name =" + transactionManagerName);
        Main.verbose("Transaction factory =" + (remote ? "remote" : "local"));
        Main.verbose("Default transaction timeout =" + timeout);
        TraceTimer.setLogWriter(logWriter);
        TraceTimer.setVerbose(verbose);
        TraceTimer.setDebug(debug);
        try {
            jotm = new Jotm(!remote, true);
        }
        catch (NamingException e) {
            System.out.println("unable to start JOTM!: " + e.getMessage());
            System.exit(1);
        }
        Runtime.getRuntime().addShutdownHook(new Main());
        try {
            ictx = new InitialContext();
        }
        catch (NamingException e) {
            System.err.println("No initial context: " + e.getExplanation());
            e.printStackTrace();
            System.exit(1);
        }
        try {
            if (userTransactionName != null) {
                ictx.rebind(userTransactionName, (Object)jotm.getUserTransaction());
                System.out.println("UserTransaction object bound in JNDI with name " + userTransactionName);
            }
            if (transactionManagerName != null) {
                ictx.rebind(transactionManagerName, (Object)jotm.getTransactionManager());
                System.out.println("TransactionManager object bound in JNDI with name " + transactionManagerName);
            }
        }
        catch (NamingException e) {
            System.err.println("UserTransaction rebind failed :" + e.getExplanation());
            e.printStackTrace();
            Main.checkRegistryMessage();
            System.exit(1);
        }
        System.out.print("JOTM is running...");
    }
}

