/*
 * Decompiled with CFR 0.152.
 */
package javax.management.modelmbean;

import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.List;
import javax.management.Descriptor;
import javax.management.DescriptorAccess;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanParameterInfo;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.DescriptorSupport;

public class ModelMBeanConstructorInfo
extends MBeanConstructorInfo
implements DescriptorAccess {
    private static final long serialVersionUID = 3862947819818064362L;
    private Descriptor consDescriptor;

    public ModelMBeanConstructorInfo(String description, Constructor constructor) {
        this(description, constructor, null);
    }

    public ModelMBeanConstructorInfo(String description, Constructor constructor, Descriptor descriptor) {
        super(description, constructor);
        this.checkAndSetDescriptor(descriptor);
    }

    public ModelMBeanConstructorInfo(String name, String description, MBeanParameterInfo[] params) {
        this(name, description, params, null);
    }

    public ModelMBeanConstructorInfo(String name, String description, MBeanParameterInfo[] params, Descriptor descriptor) {
        super(name, description, params);
        this.checkAndSetDescriptor(descriptor);
    }

    public Descriptor getDescriptor() {
        return (Descriptor)this.consDescriptor.clone();
    }

    public void setDescriptor(Descriptor descriptor) {
        if (descriptor == null) {
            this.consDescriptor = this.createDefaultDescriptor();
        } else if (this.isDescriptorValid(descriptor)) {
            this.consDescriptor = (Descriptor)descriptor.clone();
        } else {
            throw new RuntimeOperationsException(new IllegalArgumentException("Invalid descriptor"));
        }
    }

    private void checkAndSetDescriptor(Descriptor descriptor) {
        if (descriptor == null) {
            this.consDescriptor = this.createDefaultDescriptor();
        } else if (this.isDescriptorValid(descriptor)) {
            this.consDescriptor = (Descriptor)descriptor.clone();
            if (this.consDescriptor.getFieldValue("displayName") == null) {
                this.consDescriptor.setField("displayName", this.getName());
            }
        } else {
            throw new RuntimeOperationsException(new IllegalArgumentException("Invalid descriptor"));
        }
    }

    private boolean isDescriptorValid(Descriptor descriptor) {
        if (!descriptor.isValid()) {
            return false;
        }
        List<String> names = Arrays.asList(descriptor.getFieldNames());
        if (!(names.contains("name") && names.contains("descriptortype") && names.contains("role"))) {
            return false;
        }
        if (names.contains("persistpolicy") || names.contains("currencytimelimit")) {
            return false;
        }
        String name = this.getName();
        if (name == null) {
            return false;
        }
        if (!name.equals(descriptor.getFieldValue("name"))) {
            return false;
        }
        String desctype = (String)descriptor.getFieldValue("descriptortype");
        if (desctype.compareToIgnoreCase("operation") != 0) {
            return false;
        }
        String role = (String)descriptor.getFieldValue("role");
        return role.compareTo("constructor") == 0;
    }

    private Descriptor createDefaultDescriptor() {
        String[] names = new String[]{"name", "descriptorType", "role", "displayName"};
        Object[] values = new Object[]{this.getName(), "operation", "constructor", this.getName()};
        return new DescriptorSupport(names, values);
    }
}

