/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.j2ee.session;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import org.jboss.logging.Logger;
import org.mortbay.j2ee.session.IdGenerator;

public class GUIDGenerator
implements IdGenerator {
    protected static final Logger _log = Logger.getLogger((Class)(class$org$mortbay$j2ee$session$GUIDGenerator == null ? (class$org$mortbay$j2ee$session$GUIDGenerator = GUIDGenerator.class$("org.mortbay.j2ee.session.GUIDGenerator")) : class$org$mortbay$j2ee$session$GUIDGenerator));
    protected static final int SESSION_ID_BYTES = 16;
    protected static final String SESSION_ID_HASH_ALGORITHM = "MD5";
    protected static final String SESSION_ID_RANDOM_ALGORITHM = "SHA1PRNG";
    protected static final String SESSION_ID_RANDOM_ALGORITHM_ALT = "IBMSecureRandom";
    protected MessageDigest _digest = null;
    protected Random _random = null;
    static /* synthetic */ Class class$org$mortbay$j2ee$session$GUIDGenerator;

    public synchronized String nextId(HttpServletRequest request) {
        if (this._digest == null) {
            this._digest = this.getDigest();
        }
        if (this._random == null) {
            this._random = this.getRandom();
        }
        byte[] bytes = new byte[16];
        this._random.nextBytes(bytes);
        bytes = this._digest.digest(bytes);
        return this.encode(bytes);
    }

    protected String encode(byte[] data) {
        char[] out = new char[(data.length + 2) / 3 * 4];
        char[] alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+-*".toCharArray();
        int i = 0;
        int index = 0;
        while (i < data.length) {
            boolean quad = false;
            boolean trip = false;
            int val = 0xFF & data[i];
            val <<= 8;
            if (i + 1 < data.length) {
                val |= 0xFF & data[i + 1];
                trip = true;
            }
            val <<= 8;
            if (i + 2 < data.length) {
                val |= 0xFF & data[i + 2];
                quad = true;
            }
            out[index + 3] = alphabet[quad ? val & 0x3F : 64];
            out[index + 2] = alphabet[trip ? (val >>= 6) & 0x3F : 64];
            out[index + 1] = alphabet[(val >>= 6) & 0x3F];
            out[index + 0] = alphabet[(val >>= 6) & 0x3F];
            i += 3;
            index += 4;
        }
        return new String(out);
    }

    protected synchronized Random getRandom() {
        SecureRandom random = null;
        long seed = System.currentTimeMillis();
        seed ^= Runtime.getRuntime().freeMemory();
        try {
            random = SecureRandom.getInstance(SESSION_ID_RANDOM_ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            try {
                random = SecureRandom.getInstance(SESSION_ID_RANDOM_ALGORITHM_ALT);
            }
            catch (NoSuchAlgorithmException e_alt) {
                _log.error((Object)"Could not generate SecureRandom for session-id randomness", (Throwable)e);
                _log.error((Object)"Could not generate SecureRandom for session-id randomness", (Throwable)e_alt);
                return null;
            }
        }
        ((Random)random).setSeed(seed);
        return random;
    }

    protected synchronized MessageDigest getDigest() {
        MessageDigest digest = null;
        try {
            digest = MessageDigest.getInstance(SESSION_ID_HASH_ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            _log.error((Object)"Could not generate MessageDigest for session-id hashing", (Throwable)e);
            return null;
        }
        return digest;
    }

    public synchronized Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            _log.warn((Object)"could not clone IdGenerator", (Throwable)e);
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

