/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jotm;

import java.util.Collections;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.UserTransaction;
import javax.transaction.xa.Xid;
import org.objectweb.jonas_timer.TimerManager;
import org.objectweb.jotm.TraceTm;
import org.objectweb.jotm.TransactionContext;
import org.objectweb.jotm.TransactionFactory;
import org.objectweb.jotm.TransactionImpl;
import org.objectweb.jotm.XidImpl;
import org.objectweb.transaction.jta.ResourceManagerEvent;
import org.objectweb.transaction.jta.TransactionManager;

public class Current
implements UserTransaction,
TransactionManager,
Referenceable {
    private static transient ThreadLocal threadTx = new ThreadLocal();
    private static transient Map txXids = Collections.synchronizedMap(new HashMap());
    private static transient Current unique = null;
    private static transient TimerManager timermgr = null;
    private static transient TransactionFactory tm = null;
    private static final int DEFAULT_TIMEOUT = 60;
    private int transactionTimeout = 60;
    private transient int nb_bg_tx = 0;
    private transient int nb_rb_tx = 0;
    private transient int nb_cm_tx = 0;
    private transient int nb_to = 0;
    ThreadLocal eventListStack = new ThreadLocal();

    public Current() {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"no args constructor");
        }
        unique = this;
        timermgr = TimerManager.getInstance();
    }

    public Current(TransactionFactory tmfact) {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("TransactionFactory=" + tmfact));
        }
        unique = this;
        tm = tmfact;
        timermgr = TimerManager.getInstance();
    }

    public static TransactionManager getTransactionManager() {
        return unique;
    }

    public void begin() throws NotSupportedException, SystemException {
        Stack curStack;
        TransactionImpl tx;
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"begin transaction");
        }
        if ((tx = (TransactionImpl)threadTx.get()) != null) {
            throw new NotSupportedException("Nested transactions not supported");
        }
        XidImpl otid = new XidImpl("", 0);
        tx = new TransactionImpl(otid, this.transactionTimeout);
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("tx=" + tx));
        }
        try {
            tx.doAttach(0x200000);
        }
        catch (RollbackException e) {
            TraceTm.jotm.error((Object)"doAttach: RollbackException");
            throw new SystemException("RollbackException in occured in begin() " + e.getMessage());
        }
        threadTx.set(tx);
        this.putTxXid(otid, tx);
        if (timermgr != null) {
            tx.setTimer(timermgr.addTimer(tx, this.transactionTimeout, null, false));
        }
        if ((curStack = (Stack)this.eventListStack.get()) != null) {
            List list = (List)curStack.peek();
            if (list != null) {
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    ((ResourceManagerEvent)it.next()).enlistConnection(tx);
                }
            } else if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.debug((Object)"Current.begin called with null list");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        TransactionImpl tx;
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"commit transaction ");
        }
        if ((tx = (TransactionImpl)this.getTransaction()) == null) {
            throw new IllegalStateException("Cannot get Transaction for commit");
        }
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("tx=" + tx));
        }
        tx.doDetach(0x4000000);
        try {
            tx.commit();
            Object var3_2 = null;
            threadTx.set(null);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            threadTx.set(null);
            throw throwable;
        }
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        TransactionImpl tx;
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"Current.rollback()");
        }
        if ((tx = (TransactionImpl)this.getTransaction()) == null) {
            throw new IllegalStateException("Cannot get Transaction for rollback");
        }
        tx.doDetach(0x20000000);
        threadTx.set(null);
        tx.rollback();
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        TransactionImpl tx;
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"Current.setRollbackOnly()");
        }
        if ((tx = (TransactionImpl)this.getTransaction()) == null) {
            throw new IllegalStateException("Cannot get Transaction for setRollbackOnly");
        }
        tx.setRollbackOnly();
    }

    public int getStatus() throws SystemException {
        TransactionImpl tx;
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"Current.getStatus()");
        }
        if ((tx = (TransactionImpl)this.getTransaction()) == null) {
            return 6;
        }
        return tx.getStatus();
    }

    public void setTransactionTimeout(int timeout) throws SystemException {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("timeout=" + timeout));
        }
        this.transactionTimeout = timeout > 0 ? timeout : 60;
    }

    public Transaction getTransaction() throws SystemException {
        Transaction ret = (Transaction)threadTx.get();
        return ret;
    }

    public void resume(Transaction tobj) throws InvalidTransactionException, IllegalStateException, SystemException {
        Transaction mytx;
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"resume transaction");
        }
        if (tobj == null) {
            TraceTm.jotm.error((Object)"resume: null arg.");
            throw new InvalidTransactionException("resume(null) is not valid");
        }
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("tx=" + tobj));
        }
        if ((mytx = (Transaction)threadTx.get()) != null) {
            if (mytx.equals(tobj)) {
                if (TraceTm.jta.isDebugEnabled()) {
                    TraceTm.jta.debug((Object)"nothing to do");
                }
                return;
            }
            TraceTm.jotm.error((Object)"resume: already associated with another transaction.");
            throw new IllegalStateException("the thread is already associated with another transaction.");
        }
        if (!(tobj instanceof TransactionImpl)) {
            TraceTm.jotm.error((Object)"resume: non TransactionImpl arg.");
            throw new InvalidTransactionException("resume(" + tobj.getClass().getName() + ") is not valid");
        }
        threadTx.set(tobj);
        try {
            ((TransactionImpl)tobj).doAttach(0x8000000);
        }
        catch (RollbackException e) {
            TraceTm.jotm.error((Object)"RollbackException occured in resume()");
            throw new SystemException("RollbackException in occured in resume() " + e.getMessage());
        }
    }

    public Transaction suspend() throws SystemException {
        TransactionImpl tx;
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"suspend transaction");
        }
        if ((tx = (TransactionImpl)threadTx.get()) != null) {
            if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.debug((Object)("tx=" + tx));
            }
            tx.doDetach(0x2000000);
            threadTx.set(null);
        }
        return tx;
    }

    public void connectionOpened(ResourceManagerEvent event) {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"Current.connectionOpened");
        }
        Vector<ResourceManagerEvent> list = null;
        Stack<Vector<ResourceManagerEvent>> curStack = (Stack<Vector<ResourceManagerEvent>>)this.eventListStack.get();
        if (curStack == null) {
            curStack = new Stack<Vector<ResourceManagerEvent>>();
            this.eventListStack.set(curStack);
        } else {
            try {
                list = (Vector<ResourceManagerEvent>)curStack.pop();
            }
            catch (EmptyStackException e) {
                // empty catch block
            }
        }
        if (list == null) {
            list = new Vector<ResourceManagerEvent>(1);
        }
        list.add(event);
        curStack.push(list);
    }

    public void connectionClosed(ResourceManagerEvent event) {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"Current.connectionClosed");
        }
        this.removeFromCurrentStack(event);
    }

    public void connectionErrorOccured(ResourceManagerEvent event) {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"Current.connectionClosed");
        }
        this.removeFromCurrentStack(event);
    }

    private void removeFromCurrentStack(ResourceManagerEvent event) {
        Stack curStack = (Stack)this.eventListStack.get();
        List list = (List)curStack.peek();
        if (!list.remove(event)) {
            TraceTm.jotm.error((Object)"Current.removeRMEventFromStack called with event not in list");
        }
    }

    public void pushThreadLocalRMEventList(List eventList) {
        Stack<List> curStack;
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"Current.pushThreadLocalRMEventList");
        }
        if ((curStack = (Stack<List>)this.eventListStack.get()) == null) {
            curStack = new Stack<List>();
            this.eventListStack.set(curStack);
        }
        curStack.push(eventList);
    }

    public List popThreadLocalRMEventList() {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"Current.popThreadLocalRMEventList");
        }
        Stack curStack = (Stack)this.eventListStack.get();
        return (List)curStack.pop();
    }

    public Reference getReference() throws NamingException {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"Current.getReference()");
        }
        Reference ref = new Reference(this.getClass().getName(), "org.objectweb.jotm.UserTransactionFactory", null);
        Integer i = new Integer(this.transactionTimeout);
        ref.add(new StringRefAddr("jotm.timeout", i.toString()));
        return ref;
    }

    public static Current getCurrent() {
        return unique;
    }

    public static TransactionFactory getJTM() {
        if (tm == null) {
            TraceTm.jotm.error((Object)"Current: TMFactory is null!");
        }
        return tm;
    }

    public void setDefaultTimeout(int timeout) {
        if (timeout != 0) {
            this.transactionTimeout = timeout;
        }
    }

    public int getDefaultTimeout() {
        return this.transactionTimeout;
    }

    public void setPropagationContext(TransactionContext pctx, boolean isReply) {
        if (pctx == null) {
            TransactionImpl tx;
            if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.debug((Object)"Current.setPropagationContext(null) -> detach");
            }
            if ((tx = (TransactionImpl)threadTx.get()) != null) {
                if (tx.isRemovable()) {
                    this.forgetTx(tx.getXid());
                }
                threadTx.set(null);
            }
            return;
        }
        Xid xid = pctx.getXid();
        TransactionImpl tx = this.getTxXid(xid);
        if (tx == null) {
            if (!isReply) {
                if (TraceTm.jta.isDebugEnabled()) {
                    TraceTm.jta.debug((Object)"Current: setPropagationContext -> new Tx");
                }
                tx = new TransactionImpl(pctx);
                this.putTxXid(xid, tx);
            } else if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.debug((Object)("Current.setPropagationContext: unknown tx:" + xid));
            }
        } else if (isReply) {
            if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.debug((Object)("Current.setPropagationContext: updating Xid=" + xid));
            }
            tx.updatePropagationContext(pctx);
        } else if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("Current.setPropagationContext: transaction already known:" + xid));
        }
        if (!isReply) {
            threadTx.set(tx);
        }
    }

    public TransactionContext getPropagationContext(boolean hold) {
        try {
            TransactionImpl tx = (TransactionImpl)this.getTransaction();
            if (tx != null) {
                return tx.getPropagationContext(hold);
            }
        }
        catch (SystemException e) {
            TraceTm.jotm.error((Object)"getPropagationContext system exception:", (Throwable)e);
        }
        return null;
    }

    public void forgetTx(Xid xid) {
        this.removeTxXid(xid);
        threadTx.set(null);
    }

    private void putTxXid(Xid xid, TransactionImpl tx) {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("Associate tx to xid (xid=" + xid + ")"));
        }
        txXids.put(xid, tx);
    }

    private TransactionImpl getTxXid(Xid xid) {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("get tx from xid (xid=" + xid + ")"));
        }
        TransactionImpl tx = (TransactionImpl)txXids.get(xid);
        return tx;
    }

    private void removeTxXid(Xid xid) {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("remove tx from xid (xid=" + xid + ")"));
        }
        txXids.remove(xid);
    }

    public int getCurrentNumberOfTx() {
        return txXids.size();
    }

    public synchronized void incrementBeginCounter() {
        ++this.nb_bg_tx;
    }

    public int getTotalNumberOfBeginTx() {
        return this.nb_bg_tx;
    }

    public synchronized void incrementRollbackCounter() {
        ++this.nb_rb_tx;
    }

    public int getTotalNumberOfRollbackTx() {
        return this.nb_rb_tx;
    }

    public synchronized void incrementCommitCounter() {
        ++this.nb_cm_tx;
    }

    public int getTotalNumberOfCommitTx() {
        return this.nb_cm_tx;
    }

    public synchronized void resetAllTxTotalCounters() {
        this.nb_bg_tx = 0;
        this.nb_cm_tx = 0;
        this.nb_rb_tx = 0;
        this.nb_to = 0;
    }

    public synchronized void incrementTimeOutExpCounter() {
        ++this.nb_to;
    }

    public int getTotalNumberOfTimeOutExpired() {
        return this.nb_to;
    }

    public synchronized Integer[] getTxCounters() {
        Integer[] result = new Integer[]{new Integer(txXids.size()), new Integer(this.nb_bg_tx), new Integer(this.nb_cm_tx), new Integer(this.nb_rb_tx), new Integer(this.nb_to)};
        return result;
    }
}

