/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.loadbalancer;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import org.mortbay.loadbalancer.ByteBufferPool;
import org.mortbay.loadbalancer.Listener;
import org.mortbay.loadbalancer.NonBlockingQueue;
import org.mortbay.loadbalancer.Server;
import org.mortbay.util.Code;

public class Connection {
    private ByteBufferPool _bufferPool;
    private Listener _listener;
    private Server _server;
    private QueuedChannel _serverQ;
    private QueuedChannel _clientQ;
    private int _allocationTry;

    public Connection(ByteBufferPool bufferPool, Listener listener, SocketChannel client, int capacity) {
        this._bufferPool = bufferPool;
        this._listener = listener;
        this._clientQ = new QueuedChannel(capacity, client, listener.getSelector());
        this._serverQ = new QueuedChannel(capacity, null, null);
        this._clientQ.setReverse(this._serverQ);
        this._serverQ.setReverse(this._clientQ);
    }

    public SocketChannel getClientSocketChannel() {
        return this._clientQ._channel;
    }

    public synchronized void client2server(SelectionKey key) throws IOException {
        this._serverQ.read(key);
        if (!this.isAllocated()) {
            this._listener.getPolicy().allocate(this, this._serverQ, 0);
        }
    }

    public synchronized void serverWriteWakeup(SelectionKey key) throws IOException {
        this._serverQ.writeWakeup(key);
    }

    public synchronized void server2client(SelectionKey key) throws IOException {
        this._clientQ.read(key);
    }

    public synchronized void clientWriteWakeup(SelectionKey key) throws IOException {
        this._clientQ.writeWakeup(key);
    }

    public synchronized void allocate(Server server, int allocationTry) throws IOException {
        this._server = server;
        this._allocationTry = allocationTry;
        server.connect(this);
    }

    public synchronized void deallocate() throws IOException {
        this._server = null;
        this._serverQ._channel = null;
        this._serverQ._selector = null;
        this._listener.getPolicy().deallocate(this, this._serverQ, this._allocationTry);
    }

    public synchronized void connected(SocketChannel channel, Selector selector) throws IOException {
        this._serverQ._channel = channel;
        this._serverQ._selector = selector;
        if (!this._serverQ.isEmpty()) {
            this._serverQ.writeWakeup(null);
        }
        Code.debug((Object)"Connect ", (Object)this);
    }

    public boolean isAllocated() {
        return this._server != null;
    }

    public synchronized void close() {
        Code.debug((Object)"Closing ", (Object)this);
        try {
            if (this._clientQ._channel != null && this._clientQ._channel.isOpen()) {
                this._clientQ._channel.socket().setTcpNoDelay(true);
                this._clientQ._channel.socket().shutdownOutput();
                this._clientQ._channel.socket().close();
                this._clientQ._channel.close();
            }
        }
        catch (IOException e) {
            Code.warning((Throwable)e);
        }
        try {
            if (this._serverQ._channel != null && this._serverQ._channel.isOpen()) {
                this._serverQ._channel.close();
            }
        }
        catch (IOException e) {
            Code.warning((Throwable)e);
        }
    }

    public String toString() {
        return (this._clientQ._channel != null ? this._clientQ._channel.socket().getRemoteSocketAddress() + "-->" + this._clientQ._channel.socket().getLocalPort() : "?-->?") + "-->" + (this._serverQ._channel != null ? this._serverQ._channel.socket().getRemoteSocketAddress().toString() : "?");
    }

    private class QueuedChannel
    extends NonBlockingQueue {
        SocketChannel _channel;
        Selector _selector;
        QueuedChannel _reverse;

        QueuedChannel(int capacity, SocketChannel channel, Selector selector) {
            super(capacity);
            this._channel = channel;
            this._selector = selector;
        }

        void setReverse(QueuedChannel reverse) {
            this._reverse = reverse;
        }

        synchronized void read(SelectionKey key) throws IOException {
            Code.debug((Object)"Read ", (Object)key);
            if (this.isFull()) {
                key.interestOps(0xFFFFFFFE & key.interestOps());
            } else {
                SocketChannel socket_channel = (SocketChannel)key.channel();
                ByteBuffer buffer = Connection.this._bufferPool.get();
                int l = -1;
                while (!this.isFull() && (l = socket_channel.read(buffer)) > 0) {
                    buffer.flip();
                    this.write(buffer);
                    buffer = Connection.this._bufferPool.get();
                }
                Connection.this._bufferPool.add(buffer);
                if (l < 0) {
                    this.close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void write(ByteBuffer buffer) throws IOException {
            if (buffer.remaining() == 0) {
                Connection.this._bufferPool.add(buffer);
                return;
            }
            if (this.isFull()) {
                throw new IllegalStateException("Full");
            }
            if (!this.isEmpty() || this._channel == null) {
                Code.debug((Object)"QUEUE! ", (Object)buffer);
                this.queue(buffer);
            } else {
                Code.debug((Object)"Write! ", (Object)buffer);
                if (this._channel.write(buffer) < 0) {
                    Connection.this._bufferPool.add(buffer);
                    this.close();
                }
                if (buffer.remaining() > 0) {
                    Code.debug((Object)"QUEUE ", (Object)buffer);
                    this.queue(buffer);
                    Selector selector = this._selector;
                    synchronized (selector) {
                        SelectionKey key = this._channel.keyFor(this._selector);
                        if (key != null) {
                            key.interestOps(4 | key.interestOps());
                        } else {
                            key = this._channel.register(this._selector, 4, Connection.this);
                        }
                        this._selector.wakeup();
                    }
                } else {
                    Connection.this._bufferPool.add(buffer);
                }
            }
        }

        synchronized void writeWakeup(SelectionKey key) throws IOException {
            Code.debug((Object)"WRITE WAKEUP: ", (Object)key);
            boolean was_full = this.isFull();
            if (Code.debug()) {
                Code.debug((String)("was_full==" + was_full + " isEmpty()==" + this.isEmpty()));
            }
            while (!this.isEmpty()) {
                ByteBuffer buffer = (ByteBuffer)this.peek();
                Code.debug((Object)"Write  ", (Object)buffer);
                int len = this._channel.write(buffer);
                if (len < 0) {
                    Connection.this._bufferPool.add(buffer);
                    this.close();
                    return;
                }
                if (buffer.remaining() != 0) break;
                this.next();
                Connection.this._bufferPool.add(buffer);
            }
            if (key != null && this.isEmpty()) {
                key.interestOps(0xFFFFFFFB & key.interestOps());
            }
            if (was_full) {
                this._reverse.readRegister();
            }
        }

        void readRegister() throws IOException {
            Code.debug((Object)"READ REGISTER: ", (Object)this);
            SelectionKey key = this._channel.keyFor(this._selector);
            if (key != null) {
                key.interestOps(1 | key.interestOps());
            } else {
                this._channel.register(this._selector, 1, Connection.this);
            }
            this._selector.wakeup();
        }

        void close() {
            Connection.this.close();
        }
    }
}

