/*
 * Decompiled with CFR 0.152.
 */
package jde.util;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import jde.util.DynamicClassLoader;
import jde.util.ProjectClasses;

public class JdeUtilities {
    private static Map projectCache = new HashMap();
    private static String currentProjectName = "default";
    public static final String NIL = "nil";
    public static final String T = "t";
    public static final String LIST = "list";
    public static final String START_PAREN = "(";
    public static final String END_PAREN = ")";
    public static final String DOUBLE_QUOTE = "\"";
    public static final String SPACE = " ";
    public static final String START_LIST;

    public static void setProjectValues(String projectName, String projectClassPath) {
        try {
            currentProjectName = projectName;
            ProjectClasses pc = new ProjectClasses(projectClassPath);
            projectCache.put(projectName, pc);
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
    }

    public static String getCurrentProjectName() {
        return currentProjectName;
    }

    public static ProjectClasses getCurrentProjectClass() {
        return (ProjectClasses)projectCache.get(currentProjectName);
    }

    public static void classExists(String fqn) {
        try {
            DynamicClassLoader dcl = new DynamicClassLoader();
            dcl.loadClass(fqn);
            System.out.println(T);
        }
        catch (ClassNotFoundException e) {
            System.out.println(NIL);
        }
        catch (Exception e) {
            System.out.println("(error \"Trying to load " + fqn + " caused a Java exception: " + e + "\")");
        }
        catch (NoClassDefFoundError ex1) {
            System.out.println(NIL);
        }
        catch (UnsatisfiedLinkError e) {
            System.out.println("(error \"Trying to load " + fqn + " caused a Java UnsatisfiedLinkError: " + e + "\")");
        }
        catch (LinkageError e) {
            System.out.println("(error \"Trying to load " + fqn + " caused a Java LinkageError: " + e + "\")");
        }
    }

    public static void updateClassList(String classPathEntry) {
        ProjectClasses pc = (ProjectClasses)projectCache.get(JdeUtilities.getCurrentProjectName());
        try {
            if (classPathEntry != null) {
                pc.reloadClasses(classPathEntry);
            } else {
                pc.reloadClasses();
            }
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
    }

    public static void updateClassList() {
        JdeUtilities.updateClassList(null);
    }

    public static void getQualifiedName(String className) {
        ProjectClasses pc = null;
        StringBuffer result = null;
        try {
            pc = (ProjectClasses)projectCache.get(currentProjectName);
            result = new StringBuffer(START_PAREN);
            result.append(LIST);
            Iterator i = pc.getClassNames(className).iterator();
            while (i.hasNext()) {
                result.append(SPACE);
                result.append(DOUBLE_QUOTE);
                result.append(i.next().toString());
                result.append(DOUBLE_QUOTE);
            }
            result.append(END_PAREN);
            System.out.println(result.toString());
            System.out.flush();
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
    }

    public static void getJavaVersion() {
        StringBuffer sb = new StringBuffer(30);
        sb.append(DOUBLE_QUOTE);
        sb.append(System.getProperty("java.version"));
        sb.append(DOUBLE_QUOTE);
        System.out.println(sb);
        System.out.flush();
    }

    public static void exit() {
        System.exit(7);
    }

    static {
        try {
            ProjectClasses defaultProject = new ProjectClasses(System.getProperty("java.class.path"));
            projectCache.put(currentProjectName, defaultProject);
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
        StringBuffer sb = new StringBuffer(10);
        sb.append(START_PAREN);
        sb.append(LIST);
        sb.append(SPACE);
        START_LIST = sb.toString();
    }
}

