; Product version
!ifndef PRODUCT_VERSION
!define PRODUCT_VERSION "0.1.1.7"
!endif

; Constants and variables for Java version check
!define GET_JAVA_URL "http://www.java.com"
!define MIN_JAVA_VERSION "1.4"
Var JAVA_HOME
Var JAVA_VERSION

; Constants for app registry
!define SHCNE_ASSOCCHANGED 0x8000000
!define SHCNF_IDLIST 0

; Define your application name
!define APPNAME "JClic (offline)"
!define APPNAMEANDVERSION "JClic 0.1"

; MUI Settings
!define MUI_ABORTWARNING
!define MUI_ICON "${NSISDIR}\Contrib\Graphics\Icons\orange-install.ico"
!define MUI_UNICON "${NSISDIR}\Contrib\Graphics\Icons\orange-uninstall.ico"

;BGGradient 000000 800000 FFFFFF
XPStyle on

; Main Install settings
Name "${APPNAMEANDVERSION}"
InstallDir "$PROGRAMFILES\JClic"
InstallDirRegKey HKLM "Software\${APPNAME}" ""
OutFile "jclic-${PRODUCT_VERSION}.exe"

; Modern interface settings
!include "MUI.nsh"

!insertmacro MUI_PAGE_WELCOME
Page custom CheckJavaVersion "" " - Java system check"
!insertmacro MUI_PAGE_LICENSE "..\COPYING.txt"

!insertmacro MUI_PAGE_COMPONENTS
!insertmacro MUI_PAGE_DIRECTORY
!insertmacro MUI_PAGE_INSTFILES
!insertmacro MUI_PAGE_FINISH

!insertmacro MUI_UNPAGE_CONFIRM
!insertmacro MUI_UNPAGE_INSTFILES

; Set languages (first is default language)
!insertmacro MUI_LANGUAGE "English"
!insertmacro MUI_LANGUAGE "Catalan"
!insertmacro MUI_LANGUAGE "Spanish"
!insertmacro MUI_RESERVEFILE_LANGDLL

;--------------------------------
;Version Information
  VIProductVersion ${PRODUCT_VERSION}
  VIAddVersionKey /LANG=${LANG_ENGLISH} "ProductName" "JClic"
  ;VIAddVersionKey /LANG=${LANG_ENGLISH} "Comments" "A test comment"
  VIAddVersionKey /LANG=${LANG_ENGLISH} "CompanyName" "XTEC - Departament d'Educaci"
  ;VIAddVersionKey /LANG=${LANG_ENGLISH} "LegalTrademarks" "Test Application is a trademark of Fake company"
  VIAddVersionKey /LANG=${LANG_ENGLISH} "LegalCopyright" " Francesc Busquets & Departament d'Educaci de la Generalitat de Catalunya"
  VIAddVersionKey /LANG=${LANG_ENGLISH} "FileDescription" "Windows installer of JClic modules"
  VIAddVersionKey /LANG=${LANG_ENGLISH} "FileVersion" "${PRODUCT_VERSION}"
;--------------------------------


LangString javaNeeded ${LANG_CATALAN} "El JClic necessita un motor Java actualitzat, versi 1.4 o superior. El podeu descarregar gratutament des de http://www.java.com"
LangString javaNeeded ${LANG_ENGLISH} "JClic needs an updated Java engine, version 1.4 or higher. You can download it from http://www.java.com"
LangString javaNeeded ${LANG_SPANISH} "JClic necesita un motor Java actualizado, versin 1.4 o superior. Puede descargarlo gratuitamente desde http://www.java.com"
	
LangString oldJavaMsg ${LANG_CATALAN} "El sistema Java d'aquest ordinador s antic."
LangString oldJavaMsg ${LANG_ENGLISH} "There is an old version of Java installed on this computer."
LangString oldJavaMsg ${LANG_SPANISH} "El sistema Java de este ordenador es antiguo."

LangString noJavaMsg ${LANG_CATALAN} "No s'ha pogut trobar cap sistema Java installat a aquest ordinador."
LangString noJavaMsg ${LANG_ENGLISH} "It was impossible to find any Java system installed on this computer."
LangString noJavaMsg ${LANG_SPANISH} "No se ha encontrado ningn sistema Java instalado en este ordenador."

LangString standardType ${LANG_CATALAN} "Estndard"
LangString standardType ${LANG_ENGLISH} "Standard"
LangString standardType ${LANG_SPANISH} "Estndar"

LangString fullType ${LANG_CATALAN} "Completa"
LangString fullType ${LANG_ENGLISH} "Full"
LangString fullType ${LANG_SPANISH} "Completa"

LangString liteType ${LANG_CATALAN} "Mnima"
LangString liteType ${LANG_ENGLISH} "Lite"
LangString liteType ${LANG_SPANISH} "Mnima"

InstType "$(standardType)"
InstType "$(fullType)"
InstType "$(liteType)"

LangString captionStr ${LANG_CATALAN} "Installaci del JClic ${PRODUCT_VERSION}"
LangString captionStr ${LANG_ENGLISH} "JClic ${PRODUCT_VERSION} offline setup"
LangString captionStr ${LANG_SPANISH} "Instalacin de JClic ${PRODUCT_VERSION}"
Caption "$(captionStr)"

Section "-JClic core" Section1
	
	SectionIn 1 2 3

	; Set Section properties
	SetOverwrite ifnewer

	; Set Section Files and Shortcuts
	SetOutPath "$INSTDIR\"
	File "..\dist\jclic\jclic.jar"
	File "..\COPYING.txt"
	File "..\CREDITS.txt"
	File "..\CHANGES.txt"
	File "..\HACKING.txt"
	File "..\INSTALL.txt"

SectionEnd

Section "JClic player" Section2

	SectionIn 1 2 3
	
	; Set Section properties
	SetOverwrite ifnewer
	SetShellVarContext all

	; Set Section Files and Shortcuts
	SetOutPath "$INSTDIR\icons"
	File "..\dist\jclic\icons\install.ico"
	File "..\dist\jclic\icons\jclic.ico"
	SetOutPath "$INSTDIR\"
	
    CreateShortCut "$DESKTOP\JClic.lnk" "javaw" "-jar jclic.jar" "$INSTDIR\icons\jclic.ico"
	CreateDirectory "$SMPROGRAMS\JClic"
	CreateShortCut "$SMPROGRAMS\JClic\JClic.lnk" "javaw" "-jar jclic.jar" "$INSTDIR\icons\jclic.ico"
	
  ReadRegStr $R0 HKCR ".jclic" ""
  StrCmp $R0 "JCLICFile" 0 +2
    DeleteRegKey HKCR "JCLICFile"

  ReadRegStr $R0 HKCR ".jclic.zip" ""
  StrCmp $R0 "JCLIC.ZIPFile" 0 +2
    DeleteRegKey HKCR "JCLIC.ZIPFile"

  WriteRegStr HKCR ".jclic" "" "JClic.project"
  WriteRegStr HKCR ".jclic.zip" "" "JClic.project"
  WriteRegStr HKCR "JClic.project" "" "JClic project file"
  WriteRegStr HKCR "JClic.project\DefaultIcon" "" "$INSTDIR\icons\jclic.ico"
  ReadRegStr $R0 HKCR "JClic.project\shell\open\command" ""
  StrCmp $R0 "" 0 no_open
    WriteRegStr HKCR "JClic.project\shell" "" "open"
    WriteRegStr HKCR "JClic.project\shell\open\command" "" 'javaw -jar "$INSTDIR\jclic.jar" "%1"'
  no_open:

  ReadRegStr $R0 HKCR ".jclic.inst" ""
  StrCmp $R0 "JCLIC.INSTFile" 0 +2
    DeleteRegKey HKCR "JCLIC.INSTFile"
		
  WriteRegStr HKCR ".jclic.inst" "" "JClic.installer"
  WriteRegStr HKCR "JClic.installer" "" "JClic project install script"
  WriteRegStr HKCR "JClic.installer\DefaultIcon" "" "$INSTDIR\icons\install.ico"
  ReadRegStr $R0 HKCR "JClic.install\shell\open\command" ""
  StrCmp $R0 "" 0 no_open_inst
    WriteRegStr HKCR "JClic.install\shell" "" "open"
    WriteRegStr HKCR "JClic.install\shell\open\command" "" 'javaw -jar "$INSTDIR\jclic.jar" "%1"'
  no_open_inst:
	
  System::Call 'Shell32::SHChangeNotify(i ${SHCNE_ASSOCCHANGED}, i ${SHCNF_IDLIST}, i 0, i 0)'
	
SectionEnd

Section "JClic author" Section3

  sectionIn 1 2

	; Set Section properties
	SetOverwrite ifnewer
	SetShellVarContext all

	; Set Section Files and Shortcuts
	SetOutPath "$INSTDIR\"
	File "..\dist\jclic\jclicauthor.jar"
	SetOutPath "$INSTDIR\icons"
	File "..\dist\jclic\icons\author.ico"
	SetOutPath "$INSTDIR\"

	CreateShortCut "$DESKTOP\JClic Author.lnk" "javaw" "-jar jclicauthor.jar" "$INSTDIR\icons\author.ico"
	CreateDirectory "$SMPROGRAMS\JClic"
	CreateShortCut "$SMPROGRAMS\JClic\JClic Author.lnk" "javaw" "-jar jclicauthor.jar" "$INSTDIR\icons\author.ico"
	
  ReadRegStr $R0 HKCR ".jclic.zip" ""
  StrCmp $R0 "JCLIC.ZIPFile" 0 +2
    DeleteRegKey HKCR "JCLIC.ZIPFile"

  WriteRegStr HKCR ".jclic" "" "JClic.project"
  WriteRegStr HKCR ".jclic.zip" "" "JClic.project"
  WriteRegStr HKCR "JClic.project" "" "JClic project file"
  WriteRegStr HKCR "JClic.project\DefaultIcon" "" "$INSTDIR\icons\jclic.ico"
  ReadRegStr $R0 HKCR "JClic.project\shell\edit\command" ""
  StrCmp $R0 "" 0 no_edit
    ;WriteRegStr HKCR "JClic.project\shell" "" "edit"
    WriteRegStr HKCR "JClic.project\shell\edit\command" "" 'javaw -jar "$INSTDIR\jclicauthor.jar" "%1"'
  no_edit:

SectionEnd

Section /o "JClic applet" Section4

	SectionIn 2
	
	; Set Section properties
	SetOverwrite ifnewer
	SetShellVarContext all

	; Set Section Files and Shortcuts
	SetOutPath "$INSTDIR\"
	File "..\dist\jclic\jclicplugin.js"
	File "..\dist\jclic\launchApplet.js"

SectionEnd

Section "JClic reports" Section5

	SectionIn 2
	
	; Set Section properties
	SetOverwrite ifnewer
	SetShellVarContext all

	; Set Section Files and Shortcuts
	SetOutPath "$INSTDIR\"
	File "..\dist\jclic\jclicreports.jar"
	SetOutPath "$INSTDIR\icons"
	File "..\dist\jclic\icons\reports.ico"
	SetOutPath "$INSTDIR\"
	
	CreateShortCut "$DESKTOP\JClic Reports.lnk" "javaw" "-jar jclicreports.jar" "$INSTDIR\icons\reports.ico"
	CreateDirectory "$SMPROGRAMS\JClic"
	CreateShortCut "$SMPROGRAMS\JClic\JClic Reports.lnk" "javaw" "-jar jclicreports.jar" "$INSTDIR\icons\reports.ico"
		
SectionEnd


Section -FinishSection

	WriteRegStr HKLM "Software\${APPNAME}" "" "$INSTDIR"
	WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${APPNAME}" "DisplayName" "${APPNAME}"
	WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${APPNAME}" "UninstallString" "$INSTDIR\uninstall.exe"
	WriteUninstaller "$INSTDIR\uninstall.exe"

SectionEnd

; A LangString for the section name
LangString JClicPlayerDesc ${LANG_CATALAN} "Aplicaci per visualitzar i realitzar activitats JClic."
LangString JClicPlayerDesc ${LANG_ENGLISH} "Application to play JClic activities."
LangString JClicPlayerDesc ${LANG_SPANISH} "Aplicacin para visualizar i realizar actividades JClic."

LangString JClicAuthorDesc ${LANG_CATALAN} "Aplicaci per crear i modificar activitats JClic."
LangString JClicAuthorDesc ${LANG_ENGLISH} "Application to create and edit JClic activities."
LangString JClicAuthorDesc ${LANG_SPANISH} "Aplicacin para crear y modificar actividades JClic."

LangString JClicAppletDesc ${LANG_CATALAN} "Fitxers que sn necessaris noms en un servidor que allotgi applets JClic."
LangString JClicAppletDesc ${LANG_ENGLISH} "Files needed only in a server with hosted JClic applets."
LangString JClicAppletDesc ${LANG_SPANISH} "Archivos que son necesarios nicamente en un servidor que aloje applets JClic."

LangString JClicReportsDesc ${LANG_CATALAN} "Servidor d'informes."
LangString JClicReportsDesc ${LANG_ENGLISH} "Reports server."
LangString JClicReportsDesc ${LANG_SPANISH} "Servidor de informes."

; Modern install component descriptions
!insertmacro MUI_FUNCTION_DESCRIPTION_BEGIN
	!insertmacro MUI_DESCRIPTION_TEXT ${Section1} "JClic core components"
	!insertmacro MUI_DESCRIPTION_TEXT ${Section2} $(JClicPlayerDesc)
	!insertmacro MUI_DESCRIPTION_TEXT ${Section3} $(JClicAuthorDesc)
	!insertmacro MUI_DESCRIPTION_TEXT ${Section4} $(JClicAppletDesc)
	!insertmacro MUI_DESCRIPTION_TEXT ${Section5} $(JClicReportsDesc)
!insertmacro MUI_FUNCTION_DESCRIPTION_END

;Uninstall section
Section Uninstall

	SetShellVarContext all
	
	;Remove from registry...
	DeleteRegKey HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${APPNAME}"
	DeleteRegKey HKLM "SOFTWARE\${APPNAME}"


  ; Clear registry
  ReadRegStr $R0 HKCR ".jclic" ""
  StrCmp $R0 "JClic.project" 0 +2
    DeleteRegKey HKCR ".jclic"

  ReadRegStr $R0 HKCR ".jclic.zip" ""
  StrCmp $R0 "JClic.project" 0 +2
    DeleteRegKey HKCR ".jclic.zip"

  ReadRegStr $R0 HKCR ".jclic.inst" ""
  StrCmp $R0 "JClic.installer" 0 +2
    DeleteRegKey HKCR ".jclic.inst"
		
  DeleteRegKey HKCR "JClic.project"
  DeleteRegKey HKCR "JClic.installer"

  System::Call 'Shell32::SHChangeNotify(i ${SHCNE_ASSOCCHANGED}, i ${SHCNF_IDLIST}, i 0, i 0)'

	; Delete self
	Delete "$INSTDIR\uninstall.exe"

	; Delete Shortcuts
	Delete "$DESKTOP\JClic.lnk"
	Delete "$SMPROGRAMS\JClic\JClic.lnk"
	Delete "$DESKTOP\JClic Author.lnk"
	Delete "$SMPROGRAMS\JClic\JClic Author.lnk"
	Delete "$DESKTOP\JClic Reports.lnk"
	Delete "$SMPROGRAMS\JClic\JClic Reports.lnk"

	; Clean up JClic core
	Delete "$INSTDIR\activities.jar"
	Delete "$INSTDIR\dbconn.jar"
	Delete "$INSTDIR\extra.jar"
	Delete "$INSTDIR\intl.jar"
	Delete "$INSTDIR\jclic.jar"
	Delete "$INSTDIR\jclicxml.jar"
	Delete "$INSTDIR\jdom.jar"
	Delete "$INSTDIR\jmfhandlers.jar"
	Delete "$INSTDIR\player.jar"
	Delete "$INSTDIR\qt60.jar"
	Delete "$INSTDIR\qt61.jar"
	Delete "$INSTDIR\soundspi.jar"
	Delete "$INSTDIR\utilities.jar"
	Delete "$INSTDIR\COPYING.txt"
	Delete "$INSTDIR\CREDITS.txt"
	Delete "$INSTDIR\CHANGES.txt"
	Delete "$INSTDIR\HACKING.txt"
	Delete "$INSTDIR\INSTALL.txt"

	; Clean up JClic
	Delete "$INSTDIR\jclicplayer.jar"
	Delete "$INSTDIR\icons\install.ico"
	Delete "$INSTDIR\icons\jclic.ico"

	; Clean up JClic author
	Delete "$INSTDIR\jclicauthor.jar"
	Delete "$INSTDIR\icons\author.ico"

	; Clean up JClic applet
	Delete "$INSTDIR\jclicapplet.jar"
	Delete "$INSTDIR\jclicplugin.js"
	Delete "$INSTDIR\launchApplet.js"
	Delete "$INSTDIR\edu\xtec\resources\skins\blue.png"
	Delete "$INSTDIR\edu\xtec\resources\skins\blue.xml"
	Delete "$INSTDIR\edu\xtec\resources\skins\listskins.properties"
	Delete "$INSTDIR\edu\xtec\resources\skins\orange.png"
	Delete "$INSTDIR\edu\xtec\resources\skins\orange.xml"
	Delete "$INSTDIR\edu\xtec\resources\skins\simple.png"
	Delete "$INSTDIR\edu\xtec\resources\skins\simple.xml"
	Delete "$INSTDIR\edu\xtec\resources\skins\green.xml"
	Delete "$INSTDIR\edu\xtec\resources\skins\green.png"

	; Clean up JClic reports
	Delete "$INSTDIR\reportServer.jar"
	Delete "$INSTDIR\jclicreports.jar"
	
	; Remove remaining directories
	RMDir "$SMPROGRAMS\JClic"
	RMDir "$INSTDIR\edu\xtec\resources\skins\"
	RMDir "$INSTDIR\edu\xtec\resources\"
	RMDir "$INSTDIR\edu\xtec\"
	RMDir "$INSTDIR\edu\"
	RMDir "$INSTDIR\icons\"
	RMDir "$INSTDIR\"

SectionEnd

; On initialization
Function .onInit

	!insertmacro MUI_LANGDLL_DISPLAY

FunctionEnd


Function CheckJavaVersion
	ClearErrors
	ReadRegStr $JAVA_VERSION HKLM "SOFTWARE\JavaSoft\Java Runtime Environment" "CurrentVersion"
	ReadRegStr $JAVA_HOME HKLM "SOFTWARE\JavaSoft\Java Runtime Environment\$JAVA_VERSION" "JavaHome"
	
	IfErrors NoJava
	
	Push ${MIN_JAVA_VERSION}
	Push $JAVA_VERSION	
	Call CompareVersions
	Pop $R0
	StrCmp $R0 "1" JavaOk
	
  MessageBox MB_OK|MB_ICONSTOP "$(oldJavaMsg) $(javaNeeded)"
	Goto GetJava
	
NoJava:
  MessageBox MB_OK|MB_ICONSTOP "$(noJavaMsg) $(javaNeeded)"

GetJava:		
	ExecShell "open" ${GET_JAVA_URL}
	Quit

JavaOk:
	DetailPrint "Found JRE $JAVA_VERSION in path $JAVA_HOME"
	
FunctionEnd


;-----------------------------------------------------------------------------
 ; CompareVersions
 ; input:
 ;    top of stack = existing version
 ;    top of stack-1 = needed version
 ; output:
 ;    top of stack = 1 if current version => neded version, else 0
 ; version is a string in format "xx.xx.xx.xx" (number of interger sections 
 ; can be different in needed and existing versions)

Function CompareVersions
   ; stack: existing ver | needed ver
   Exch $R0 
   Exch
   Exch $R1 
   ; stack: $R1|$R0

   Push $R1
   Push $R0
   ; stack: e|n|$R1|$R0

   ClearErrors
   loop:
      IfErrors VersionNotFound
      Strcmp $R0 "" VersionTestEnd

      Call ParseVersion
      Pop $R0
      Exch

      Call ParseVersion
      Pop $R1 
      Exch

      IntCmp $R1 $R0 +1 VersionOk VersionNotFound
      Pop $R0
      Push $R0

   goto loop
   
   VersionTestEnd:
      Pop $R0
      Pop $R1
      Push $R1
      Push $R0
      StrCmp $R0 $R1 VersionOk VersionNotFound

   VersionNotFound:
      StrCpy $R0 "0"
      Goto end
      
   VersionOk:
      StrCpy $R0 "1"
end:
   ; stack: e|n|$R1|$R0
   Exch $R0
   Pop $R0
   Exch $R0
   ; stack: res|$R1|$R0
   Exch
   ; stack: $R1|res|$R0
   Pop $R1
   ; stack: res|$R0
   Exch
   Pop $R0
   ; stack: res
FunctionEnd

;---------------------------------------------------------------------------------------
 ; ParseVersion
 ; input:
 ;      top of stack = version string ("xx.xx.xx.xx")
 ; output: 
 ;      top of stack   = first number in version ("xx")
 ;      top of stack-1 = rest of the version string ("xx.xx.xx")
Function ParseVersion
   Exch $R1 ; version
   Push $R2
   Push $R3

   StrCpy $R2 1
   loop:
      StrCpy $R3 $R1 1 $R2
      StrCmp $R3 "." loopend
      StrLen $R3 $R1
      IntCmp $R3 $R2 loopend loopend
      IntOp $R2 $R2 + 1
      Goto loop
   loopend:
   Push $R1
   StrCpy $R1 $R1 $R2
   Exch $R1

   StrLen $R3 $R1
   IntOp $R3 $R3 - $R2
   IntOp $R2 $R2 + 1
   StrCpy $R1 $R1 $R3 $R2

   Push $R1
   
   Exch 2
   Pop $R3
   
   Exch 2
   Pop $R2

   Exch 2
   Pop $R1
FunctionEnd
;---------------------------------------------------------------------------------------

; eof
