/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.analysis;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.antlr.analysis.DFA;
import org.antlr.codegen.CodeGenerator;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.tool.Grammar;
import org.antlr.tool.GrammarAST;

public abstract class SemanticContext {
    public static final SemanticContext EMPTY_SEMANTIC_CONTEXT = new Predicate();

    public abstract SemanticContext getGatedPredicateContext();

    public abstract StringTemplate genExpr(CodeGenerator var1, StringTemplateGroup var2, DFA var3);

    public abstract boolean isSyntacticPredicate();

    public void trackUseOfSyntacticPredicates(Grammar g) {
    }

    public static SemanticContext and(SemanticContext a, SemanticContext b) {
        if (a == EMPTY_SEMANTIC_CONTEXT || a == null) {
            return b;
        }
        if (b == EMPTY_SEMANTIC_CONTEXT || b == null) {
            return a;
        }
        if (a.equals(b)) {
            return a;
        }
        return new AND(a, b);
    }

    public static SemanticContext or(SemanticContext a, SemanticContext b) {
        if (a == EMPTY_SEMANTIC_CONTEXT || a == null) {
            return b;
        }
        if (b == EMPTY_SEMANTIC_CONTEXT || b == null) {
            return a;
        }
        return new OR(a, b);
    }

    public static SemanticContext not(SemanticContext a) {
        return new NOT(a);
    }

    public static class AND
    extends SemanticContext {
        protected SemanticContext left;
        protected SemanticContext right;

        public StringTemplate genExpr(CodeGenerator generator, StringTemplateGroup templates, DFA dfa) {
            StringTemplate eST = null;
            eST = templates != null ? templates.getInstanceOf("andPredicates") : new StringTemplate("($left$&&$right$)");
            eST.setAttribute("left", (Object)this.left.genExpr(generator, templates, dfa));
            eST.setAttribute("right", (Object)this.right.genExpr(generator, templates, dfa));
            return eST;
        }

        public SemanticContext getGatedPredicateContext() {
            SemanticContext gatedLeft = this.left.getGatedPredicateContext();
            SemanticContext gatedRight = this.right.getGatedPredicateContext();
            if (gatedLeft == null) {
                return gatedRight;
            }
            if (gatedRight == null) {
                return gatedLeft;
            }
            return new AND(gatedLeft, gatedRight);
        }

        public boolean isSyntacticPredicate() {
            boolean bl = false;
            if (this.left.isSyntacticPredicate() || this.right.isSyntacticPredicate()) {
                bl = true;
            }
            return bl;
        }

        public void trackUseOfSyntacticPredicates(Grammar g) {
            this.left.trackUseOfSyntacticPredicates(g);
            this.right.trackUseOfSyntacticPredicates(g);
        }

        public String toString() {
            return "(" + this.left + "&&" + this.right + ')';
        }

        public AND(SemanticContext a, SemanticContext b) {
            this.left = a;
            this.right = b;
        }
    }

    public static class OR
    extends SemanticContext {
        protected Set operands = new HashSet();

        public StringTemplate genExpr(CodeGenerator generator, StringTemplateGroup templates, DFA dfa) {
            StringTemplate eST = null;
            eST = templates != null ? templates.getInstanceOf("orPredicates") : new StringTemplate("($first(operands)$$rest(operands):{o | ||$o$}$)");
            Iterator it = this.operands.iterator();
            while (it.hasNext()) {
                SemanticContext semctx = (SemanticContext)it.next();
                eST.setAttribute("operands", (Object)semctx.genExpr(generator, templates, dfa));
            }
            return eST;
        }

        public SemanticContext getGatedPredicateContext() {
            OR result = null;
            Iterator it = this.operands.iterator();
            while (it.hasNext()) {
                SemanticContext semctx = (SemanticContext)it.next();
                SemanticContext gatedPred = semctx.getGatedPredicateContext();
                if (gatedPred == null) continue;
                result = new OR(result, gatedPred);
            }
            return result;
        }

        public boolean isSyntacticPredicate() {
            Iterator it = this.operands.iterator();
            while (it.hasNext()) {
                SemanticContext semctx = (SemanticContext)it.next();
                if (!semctx.isSyntacticPredicate()) continue;
                return true;
            }
            return false;
        }

        public void trackUseOfSyntacticPredicates(Grammar g) {
            Iterator it = this.operands.iterator();
            while (it.hasNext()) {
                SemanticContext semctx = (SemanticContext)it.next();
                semctx.trackUseOfSyntacticPredicates(g);
            }
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("(");
            int i = 0;
            Iterator it = this.operands.iterator();
            while (it.hasNext()) {
                SemanticContext semctx = (SemanticContext)it.next();
                if (i > 0) {
                    buf.append("||");
                }
                buf.append(semctx.toString());
                ++i;
            }
            buf.append(")");
            return buf.toString();
        }

        public OR(SemanticContext a, SemanticContext b) {
            if (a instanceof OR) {
                this.operands.addAll(((OR)a).operands);
            } else if (a != null) {
                this.operands.add(a);
            }
            if (b instanceof OR) {
                this.operands.addAll(((OR)b).operands);
            } else if (b != null) {
                this.operands.add(b);
            }
        }
    }

    public static class NOT
    extends SemanticContext {
        protected SemanticContext ctx;

        public StringTemplate genExpr(CodeGenerator generator, StringTemplateGroup templates, DFA dfa) {
            StringTemplate eST = null;
            eST = templates != null ? templates.getInstanceOf("notPredicate") : new StringTemplate("?!($pred$)");
            eST.setAttribute("pred", (Object)this.ctx.genExpr(generator, templates, dfa));
            return eST;
        }

        public SemanticContext getGatedPredicateContext() {
            SemanticContext p = this.ctx.getGatedPredicateContext();
            if (p == null) {
                return null;
            }
            return new NOT(p);
        }

        public boolean isSyntacticPredicate() {
            return this.ctx.isSyntacticPredicate();
        }

        public void trackUseOfSyntacticPredicates(Grammar g) {
            this.ctx.trackUseOfSyntacticPredicates(g);
        }

        public String toString() {
            return "!(" + this.ctx + ')';
        }

        public NOT(SemanticContext ctx) {
            this.ctx = ctx;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Predicate
    extends SemanticContext {
        public static final int INVALID_PRED_VALUE = -1;
        public static final int FALSE_PRED = 0;
        public static final int TRUE_PRED = 1;
        protected GrammarAST predicate;
        protected boolean gated;
        protected boolean synpred;
        protected int constantValue;

        public boolean equals(Object o) {
            if (!(o instanceof Predicate)) {
                return false;
            }
            return this.predicate.getText().equals(((Predicate)o).predicate.getText());
        }

        public int hashCode() {
            if (this.predicate == null) {
                return 0;
            }
            return this.predicate.getText().hashCode();
        }

        public StringTemplate genExpr(CodeGenerator generator, StringTemplateGroup templates, DFA dfa) {
            StringTemplate eST = null;
            if (templates != null) {
                if (this.synpred) {
                    eST = templates.getInstanceOf("evalSynPredicate");
                } else {
                    eST = templates.getInstanceOf("evalPredicate");
                    generator.grammar.decisionsWhoseDFAsUsesSemPreds.add(dfa);
                }
                String predEnclosingRuleName = this.predicate.getEnclosingRule();
                if (generator != null) {
                    eST.setAttribute("pred", (Object)generator.translateAction(predEnclosingRuleName, this.predicate));
                }
            } else {
                eST = new StringTemplate("$pred$");
                eST.setAttribute("pred", (Object)this.toString());
                return eST;
            }
            if (generator != null) {
                String description = generator.target.getTargetStringLiteralFromString(this.toString());
                eST.setAttribute("description", (Object)description);
            }
            return eST;
        }

        public SemanticContext getGatedPredicateContext() {
            if (this.gated) {
                return this;
            }
            return null;
        }

        public boolean isSyntacticPredicate() {
            boolean bl = false;
            if (this.predicate != null && this.predicate.getType() == 36) {
                bl = true;
            }
            return bl;
        }

        public void trackUseOfSyntacticPredicates(Grammar g) {
            if (this.synpred) {
                g.synPredNamesUsedInDFA.add(this.predicate.getText());
            }
        }

        public String toString() {
            if (this.predicate == null) {
                return "<nopred>";
            }
            return this.predicate.getText();
        }

        private final /* synthetic */ void this() {
            this.gated = false;
            this.synpred = false;
            this.constantValue = -1;
        }

        public Predicate() {
            this.this();
            this.predicate = new GrammarAST();
            this.gated = false;
        }

        public Predicate(GrammarAST predicate) {
            this.this();
            this.predicate = predicate;
            boolean bl = false;
            if (predicate.getType() == 35) {
                bl = true;
            }
            this.gated = bl;
            boolean bl2 = false;
            if (predicate.getType() == 36) {
                bl2 = true;
            }
            this.synpred = bl2;
        }

        public Predicate(Predicate p) {
            this.this();
            this.predicate = p.predicate;
            this.gated = p.gated;
            this.synpred = p.synpred;
            this.constantValue = p.constantValue;
        }
    }

    public static class TruePredicate
    extends Predicate {
        public StringTemplate genExpr(CodeGenerator generator, StringTemplateGroup templates, DFA dfa) {
            if (templates != null) {
                return templates.getInstanceOf("true");
            }
            return new StringTemplate("true");
        }

        public String toString() {
            return "true";
        }

        public TruePredicate() {
            this.constantValue = 1;
        }
    }
}

