/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.swing;

import ca.odell.glazedlists.swing.JEventListPanel;
import ca.odell.glazedlists.swing.LayoutDecorator;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class ListLayout
extends LayoutDecorator {
    private final List gridComponents = new ArrayList();
    private final FormLayout formLayout;
    private final JEventListPanel.Format format;
    private RowSpec[] rowSpecs;
    private ColumnSpec[] columnSpecs;
    private RowSpec gapRow;
    private ColumnSpec gapColumn;
    private Container container;
    private int elementColumns = 1;
    private int elementRows = Integer.MAX_VALUE;

    public ListLayout(Container container, JEventListPanel.Format format) {
        this.container = container;
        this.format = format;
        this.formLayout = new FormLayout("");
        this.columnSpecs = format.getElementColumns();
        this.rowSpecs = format.getElementRows();
        this.gapRow = format.getGapRow();
        this.gapColumn = format.getGapColumn();
        this.delegateLayout = this.formLayout;
    }

    public void setElementColumns(int elementColumns) {
        if (elementColumns == this.elementColumns) {
            return;
        }
        this.setElementRowsAndColumns(Integer.MAX_VALUE, elementColumns);
    }

    public void setElementRows(int elementRows) {
        if (elementRows == this.elementRows) {
            return;
        }
        this.setElementRowsAndColumns(elementRows, Integer.MAX_VALUE);
    }

    private void setElementRowsAndColumns(int elementRows, int elementColumns) {
        int logicalRowCountBefore = this.logicalRowCount();
        int logicalColumnCountBefore = this.logicalColumnCount();
        this.elementRows = elementRows;
        this.elementColumns = elementColumns;
        this.fixCellCount(logicalRowCountBefore, logicalColumnCountBefore);
    }

    private void fixCellCount(int logicalRowCountBefore, int logicalColumnCountBefore) {
        int c;
        int r;
        int logicalColumnCountAfter = this.logicalColumnCount();
        int logicalRowCountAfter = this.logicalRowCount();
        for (r = logicalRowCountBefore; r < logicalRowCountAfter; ++r) {
            this.insertLogicalRow(r);
        }
        for (c = logicalColumnCountBefore; c < logicalColumnCountAfter; ++c) {
            this.insertLogicalColumn(c);
        }
        this.reassignConstraints();
        for (r = logicalRowCountBefore - 1; r >= logicalRowCountAfter; --r) {
            this.removeLogicalRow(r);
        }
        for (c = logicalColumnCountBefore - 1; c >= logicalColumnCountAfter; --c) {
            this.removeLogicalColumn(c);
        }
    }

    private CellConstraints deriveCellConstraints(int component, int logicalColumn, int logicalRow) {
        CellConstraints constraints = this.format.getConstraints(component);
        constraints = (CellConstraints)constraints.clone();
        constraints.gridX = constraints.gridX + (this.logicalToLayoutColumn(logicalColumn) + (logicalColumn > 0 && this.gapColumn != null ? 1 : 0));
        constraints.gridY = constraints.gridY + (this.logicalToLayoutRow(logicalRow) + (logicalRow > 0 && this.gapRow != null ? 1 : 0));
        return constraints;
    }

    public void addLayoutComponent(Component component, Object constraints) {
        Constraints listLayoutConstraints = (Constraints)constraints;
        int index = listLayoutConstraints.getIndex();
        int formConstraints = listLayoutConstraints.getFormConstraints();
        CellComponents cellComponents = (CellComponents)this.gridComponents.get(index);
        cellComponents.components.add(component);
        cellComponents.constraints.add(listLayoutConstraints);
        CellConstraints cellConstraints = this.deriveCellConstraints(formConstraints, this.logicalColumn(index), this.logicalRow(index));
        super.addLayoutComponent(component, cellConstraints);
    }

    private int logicalColumn(int index) {
        if (this.elementRows == Integer.MAX_VALUE) {
            return index % this.elementColumns;
        }
        return index / this.elementRows;
    }

    private int logicalRow(int index) {
        if (this.elementRows == Integer.MAX_VALUE) {
            return index / this.elementColumns;
        }
        return index % this.elementRows;
    }

    private int logicalRowCount() {
        if (this.elementRows == Integer.MAX_VALUE) {
            return (this.gridComponents.size() + this.elementColumns - 1) / this.elementColumns;
        }
        return Math.min(this.gridComponents.size(), this.elementRows);
    }

    private int logicalColumnCount() {
        if (this.elementRows == Integer.MAX_VALUE) {
            return Math.min(this.gridComponents.size(), this.elementColumns);
        }
        return (this.gridComponents.size() + this.elementRows - 1) / this.elementRows;
    }

    private void insertLogicalRow(int index) {
        int baseRow = this.logicalToLayoutRow(index);
        if (index != 0 && this.gapRow != null) {
            this.insertRow(baseRow, this.gapRow);
            ++baseRow;
        }
        for (int r = 0; r < this.rowSpecs.length; ++r) {
            this.insertRow(baseRow + r, this.rowSpecs[r]);
        }
    }

    private void insertLogicalColumn(int index) {
        int baseColumn = this.logicalToLayoutColumn(index);
        if (index != 0 && this.gapColumn != null) {
            this.insertColumn(baseColumn, this.gapColumn);
            ++baseColumn;
        }
        for (int c = 0; c < this.columnSpecs.length; ++c) {
            this.insertColumn(baseColumn + c, this.columnSpecs[c]);
        }
    }

    private void removeLogicalRow(int index) {
        int baseRow = this.logicalToLayoutRow(index);
        if (index != 0 && this.gapRow != null) {
            this.formLayout.removeRow(baseRow + 1);
        }
        for (int r = 0; r < this.rowSpecs.length; ++r) {
            this.formLayout.removeRow(baseRow + 1);
        }
    }

    private void removeLogicalColumn(int index) {
        int baseColumn = this.logicalToLayoutColumn(index);
        if (index != 0 && this.gapColumn != null) {
            this.formLayout.removeColumn(baseColumn + 1);
        }
        for (int c = 0; c < this.columnSpecs.length; ++c) {
            this.formLayout.removeColumn(baseColumn + 1);
        }
    }

    private int logicalToLayoutRow(int row) {
        if (row == 0) {
            return 0;
        }
        return row * this.rowSpecs.length + (this.gapRow == null ? 0 : row - 1);
    }

    private int logicalToLayoutColumn(int column) {
        if (column == 0) {
            return 0;
        }
        return column * this.columnSpecs.length + (this.gapColumn == null ? 0 : column - 1);
    }

    public void insertIndex(int index) {
        int logicalColumnCountBefore = this.logicalColumnCount();
        int logicalRowCountBefore = this.logicalRowCount();
        this.gridComponents.add(index, new CellComponents());
        this.fixCellCount(logicalRowCountBefore, logicalColumnCountBefore);
    }

    public void removeIndex(int index) {
        int logicalColumnCountBefore = this.logicalColumnCount();
        int logicalRowCountBefore = this.logicalRowCount();
        this.gridComponents.remove(index);
        this.fixCellCount(logicalRowCountBefore, logicalColumnCountBefore);
    }

    public void updateIndex(int index) {
        CellComponents cellComponents = (CellComponents)this.gridComponents.get(index);
        List<Component> activeComponents = Arrays.asList(this.container.getComponents());
        int i = 0;
        while (i < cellComponents.components.size()) {
            Component component = (Component)cellComponents.components.get(i);
            if (!activeComponents.contains(component)) {
                cellComponents.components.remove(i);
                cellComponents.constraints.remove(i);
                continue;
            }
            ++i;
        }
    }

    private void reassignConstraints() {
        this.formLayout.invalidateLayout(this.container);
        for (int i = 0; i < this.gridComponents.size(); ++i) {
            CellComponents cellComponents = (CellComponents)this.gridComponents.get(i);
            for (int j = 0; j < cellComponents.components.size(); ++j) {
                Component component = (Component)cellComponents.components.get(j);
                Constraints constraints = (Constraints)cellComponents.constraints.get(j);
                this.formLayout.addLayoutComponent(component, (Object)this.deriveCellConstraints(constraints.getFormConstraints(), this.logicalColumn(i), this.logicalRow(i)));
            }
        }
    }

    public int size() {
        return this.gridComponents.size();
    }

    private void insertRow(int index, RowSpec rowSpec) {
        if (index == this.formLayout.getRowCount()) {
            this.formLayout.appendRow(rowSpec);
        } else {
            this.formLayout.insertRow(index + 1, rowSpec);
        }
    }

    private void insertColumn(int index, ColumnSpec columnSpec) {
        if (index == this.formLayout.getColumnCount()) {
            this.formLayout.appendColumn(columnSpec);
        } else {
            this.formLayout.insertColumn(index + 1, columnSpec);
        }
    }

    public static class Constraints {
        private int formConstraints;
        private int index;

        public Constraints(int component, int index) {
            this.formConstraints = component;
            this.index = index;
        }

        public int getFormConstraints() {
            return this.formConstraints;
        }

        public int getIndex() {
            return this.index;
        }
    }

    private static class CellComponents {
        private List components = new ArrayList(1);
        private List constraints = new ArrayList(1);

        private CellComponents() {
        }
    }
}

