/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.gui;

import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.gui.AbstractTableComparatorChooser;
import ca.odell.glazedlists.gui.AdvancedTableFormat;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.impl.sort.ComparatorChain;
import ca.odell.glazedlists.impl.sort.ReverseComparator;
import ca.odell.glazedlists.impl.sort.TableColumnComparator;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class SortingState {
    private static final Pattern FROM_STRING_PATTERN = Pattern.compile("^\\s*column\\s+(\\d+)(\\s+comparator\\s+(\\d+))?(\\s+(reversed))?\\s*$", 2);
    protected static final int COLUMN_UNSORTED = 0;
    protected static final int COLUMN_PRIMARY_SORTED = 1;
    protected static final int COLUMN_PRIMARY_SORTED_REVERSE = 2;
    protected static final int COLUMN_PRIMARY_SORTED_ALTERNATE = 3;
    protected static final int COLUMN_PRIMARY_SORTED_ALTERNATE_REVERSE = 4;
    protected static final int COLUMN_SECONDARY_SORTED = 5;
    protected static final int COLUMN_SECONDARY_SORTED_REVERSE = 6;
    protected static final int COLUMN_SECONDARY_SORTED_ALTERNATE = 7;
    protected static final int COLUMN_SECONDARY_SORTED_ALTERNATE_REVERSE = 8;
    protected List sortingColumns;
    protected List recentlyClickedColumns = new ArrayList(2);
    private final AbstractTableComparatorChooser tableComparatorChooser;
    private final PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    static /* synthetic */ Class class$ca$odell$glazedlists$impl$gui$SortingState;

    public SortingState(AbstractTableComparatorChooser tableComparatorChooser) {
        this.tableComparatorChooser = tableComparatorChooser;
    }

    public AbstractTableComparatorChooser getTableComparatorChooser() {
        return this.tableComparatorChooser;
    }

    public void fireSortingChanged() {
        this.changeSupport.firePropertyChange("comparator", null, null);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public Comparator buildComparator() {
        if (this.recentlyClickedColumns.isEmpty()) {
            return null;
        }
        ArrayList<Comparator> comparators = new ArrayList<Comparator>(this.recentlyClickedColumns.size());
        Iterator i = this.recentlyClickedColumns.iterator();
        while (i.hasNext()) {
            SortingColumn sortingColumn = (SortingColumn)i.next();
            Comparator comparator = sortingColumn.getComparator();
            if (comparator == null) {
                throw new IllegalStateException();
            }
            comparators.add(comparator);
        }
        return GlazedLists.chainComparators(comparators);
    }

    public List getSortingColumnIndexes() {
        ArrayList<Integer> sortingColumns = new ArrayList<Integer>();
        List recentlyClickedColumns = this.getRecentlyClickedColumns();
        for (int c = 0; c < recentlyClickedColumns.size(); ++c) {
            SortingColumn clickedColumn = (SortingColumn)recentlyClickedColumns.get(c);
            sortingColumns.add(new Integer(clickedColumn.getColumn()));
        }
        return sortingColumns;
    }

    public void appendComparator(int column, int comparatorIndex, boolean reverse) {
        if (column > this.getColumns().size()) {
            throw new IllegalArgumentException("invalid column " + column + ", must be in range 0, " + this.sortingColumns.size());
        }
        if (comparatorIndex >= ((SortingColumn)this.sortingColumns.get(column)).getComparators().size()) {
            throw new IllegalArgumentException("invalid comparator index " + comparatorIndex + ", must be in range 0, " + ((SortingColumn)this.sortingColumns.get(column)).getComparators().size());
        }
        if (this.recentlyClickedColumns.contains(this.getColumns().get(column))) {
            return;
        }
        SortingColumn sortingColumn = (SortingColumn)this.sortingColumns.get(column);
        sortingColumn.setComparatorIndex(comparatorIndex);
        sortingColumn.setReverse(reverse);
        this.recentlyClickedColumns.add(sortingColumn);
    }

    public void detectStateFromComparator(Comparator foreignComparator) {
        List<Comparator> comparatorsList;
        this.clearComparators();
        if (foreignComparator == null) {
            comparatorsList = Collections.EMPTY_LIST;
        } else if (foreignComparator instanceof ComparatorChain) {
            ComparatorChain chain = (ComparatorChain)foreignComparator;
            comparatorsList = Arrays.asList(chain.getComparators());
        } else {
            comparatorsList = Collections.singletonList(foreignComparator);
        }
        Iterator i = comparatorsList.iterator();
        while (i.hasNext()) {
            Comparator comparator = (Comparator)i.next();
            boolean reverse = false;
            if (comparator instanceof ReverseComparator) {
                reverse = true;
                comparator = ((ReverseComparator)comparator).getSourceComparator();
            }
            for (int c = 0; c < this.sortingColumns.size(); ++c) {
                int comparatorIndex;
                if (this.recentlyClickedColumns.contains(this.sortingColumns.get(c)) || (comparatorIndex = ((SortingColumn)this.sortingColumns.get(c)).getComparators().indexOf(comparator)) == -1) continue;
                SortingColumn columnClickTracker = (SortingColumn)this.sortingColumns.get(c);
                columnClickTracker.setComparatorIndex(comparatorIndex);
                columnClickTracker.setReverse(reverse);
                this.recentlyClickedColumns.add(columnClickTracker);
            }
        }
    }

    public void clearComparators() {
        Iterator i = this.recentlyClickedColumns.iterator();
        while (i.hasNext()) {
            SortingColumn sortingColumn = (SortingColumn)i.next();
            sortingColumn.clear();
        }
        this.recentlyClickedColumns.clear();
    }

    public void rebuildColumns(TableFormat tableFormat) {
        int columnCount = tableFormat.getColumnCount();
        this.sortingColumns = new ArrayList(columnCount);
        for (int i = 0; i < columnCount; ++i) {
            this.sortingColumns.add(new SortingColumn(tableFormat, i));
        }
        this.recentlyClickedColumns.clear();
    }

    public List getColumns() {
        return this.sortingColumns;
    }

    public List getRecentlyClickedColumns() {
        return this.recentlyClickedColumns;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        Iterator i = this.getSortingColumnIndexes().iterator();
        while (i.hasNext()) {
            int columnIndex = (Integer)i.next();
            SortingColumn sortingColumn = (SortingColumn)this.getColumns().get(columnIndex);
            result.append("column ");
            result.append(columnIndex);
            int comparatorIndex = sortingColumn.getComparatorIndex();
            if (comparatorIndex != 0) {
                result.append(" comparator ");
                result.append(comparatorIndex);
            }
            if (sortingColumn.isReverse()) {
                result.append(" reversed");
            }
            if (!i.hasNext()) continue;
            result.append(", ");
        }
        return result.toString();
    }

    public void fromString(String stringEncoded) {
        this.clearComparators();
        String[] parts = stringEncoded.split(",");
        for (int p = 0; p < parts.length; ++p) {
            boolean reversedComparator;
            if (parts[p].trim().length() == 0) continue;
            Matcher matcher = FROM_STRING_PATTERN.matcher(parts[p]);
            if (!matcher.find()) {
                throw new IllegalArgumentException("Failed to parse column spec, \"" + parts[p] + "\"");
            }
            int columnIndex = Integer.parseInt(matcher.group(1));
            int comparatorIndex = matcher.group(3) == null ? 0 : Integer.parseInt(matcher.group(3));
            boolean bl = reversedComparator = matcher.group(5) != null;
            if (columnIndex >= this.sortingColumns.size() || comparatorIndex >= ((SortingColumn)this.sortingColumns.get(columnIndex)).getComparators().size()) continue;
            this.appendComparator(columnIndex, comparatorIndex, reversedComparator);
        }
    }

    public class SortingColumn {
        private final int column;
        private final List comparators = new ArrayList(1);
        private boolean reverse = false;
        private int comparatorIndex = -1;
        static final /* synthetic */ boolean $assertionsDisabled;

        public SortingColumn(TableFormat tableFormat, int column) {
            this.column = column;
            if (tableFormat instanceof AdvancedTableFormat) {
                AdvancedTableFormat advancedTableFormat = (AdvancedTableFormat)tableFormat;
                Comparator columnComparator = advancedTableFormat.getColumnComparator(column);
                if (columnComparator != null) {
                    this.comparators.add(new TableColumnComparator(tableFormat, column, columnComparator));
                }
            } else {
                this.comparators.add(new TableColumnComparator(tableFormat, column));
            }
        }

        public void clear() {
            this.reverse = false;
            this.comparatorIndex = -1;
        }

        public int getColumn() {
            return this.column;
        }

        public void setComparatorIndex(int comparatorIndex) {
            if (!$assertionsDisabled && comparatorIndex >= this.comparators.size()) {
                throw new AssertionError();
            }
            this.comparatorIndex = comparatorIndex;
        }

        public int getComparatorIndex() {
            return this.comparatorIndex;
        }

        public List getComparators() {
            return this.comparators;
        }

        public Comparator getComparator() {
            if (this.comparatorIndex == -1) {
                return null;
            }
            Comparator comparator = (Comparator)this.comparators.get(this.getComparatorIndex());
            if (this.isReverse()) {
                comparator = GlazedLists.reverseComparator(comparator);
            }
            return comparator;
        }

        public boolean isReverse() {
            return this.reverse;
        }

        public void setReverse(boolean reverse) {
            this.reverse = reverse;
        }

        public int getSortingStyle() {
            boolean primaryComparator;
            if (this.comparatorIndex == -1) {
                return 0;
            }
            boolean primaryColumn = !SortingState.this.recentlyClickedColumns.isEmpty() && SortingState.this.recentlyClickedColumns.get(0) == this;
            boolean bl = primaryComparator = this.getComparatorIndex() == 0;
            if (primaryColumn) {
                if (!this.isReverse()) {
                    if (primaryComparator) {
                        return 1;
                    }
                    return 3;
                }
                if (primaryComparator) {
                    return 2;
                }
                return 4;
            }
            if (!this.isReverse()) {
                if (primaryComparator) {
                    return 5;
                }
                return 7;
            }
            if (primaryComparator) {
                return 6;
            }
            return 8;
        }

        static {
            $assertionsDisabled = !(class$ca$odell$glazedlists$impl$gui$SortingState == null ? (class$ca$odell$glazedlists$impl$gui$SortingState = SortingState.class$("ca.odell.glazedlists.impl.gui.SortingState")) : class$ca$odell$glazedlists$impl$gui$SortingState).desiredAssertionStatus();
        }
    }
}

