/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.impl.Grouper;
import ca.odell.glazedlists.impl.adt.barcode2.Element;
import ca.odell.glazedlists.impl.adt.barcode2.SimpleTree;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public final class GroupingList
extends TransformedList {
    private SimpleTree groupLists = new SimpleTree();
    private final Grouper grouper;

    public GroupingList(EventList source) {
        this(source, GlazedLists.comparableComparator());
    }

    public GroupingList(EventList source, Comparator comparator) {
        this(new SortedList(source, comparator), comparator, null);
    }

    private GroupingList(SortedList source, Comparator comparator, Void dummyParameter) {
        super(source);
        GrouperClient grouperClient = new GrouperClient();
        this.grouper = new Grouper(source, grouperClient);
        for (int i = 0; i < this.grouper.getBarcode().colourSize(Grouper.UNIQUE); ++i) {
            grouperClient.insertGroupList(i);
        }
        source.addListEventListener(this);
    }

    public int size() {
        return this.grouper.getBarcode().colourSize(Grouper.UNIQUE);
    }

    protected int getSourceIndex(int index) {
        return this.grouper.getBarcode().getIndex(index, Grouper.UNIQUE);
    }

    protected boolean isWritable() {
        return true;
    }

    public void listChanged(ListEvent listChanges) {
        this.updates.beginEvent(true);
        this.grouper.listChanged(listChanges);
        this.updates.commitEvent();
    }

    public Object get(int x0) {
        int index = x0;
        return (List)this.groupLists.get(index).get();
    }

    public Object remove(int x0) {
        int index = x0;
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException("Cannot remove at " + index + " on list of size " + this.size());
        }
        List removed = (List)this.get(index);
        ArrayList result = new ArrayList(removed);
        removed.clear();
        return result;
    }

    public Object set(int x0, Object x1) {
        int index = x0;
        List value = (List)x1;
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException("Cannot set at " + index + " on list of size " + this.size());
        }
        this.updates.beginEvent(true);
        List result = (List)this.remove(index);
        this.add(index, value);
        this.updates.commitEvent();
        return result;
    }

    public void add(int x0, Object x1) {
        int index = x0;
        List value = (List)x1;
        this.source.addAll(value);
    }

    public void dispose() {
        ((SortedList)this.source).dispose();
        super.dispose();
    }

    private class GroupList
    extends AbstractList {
        private Element treeNode;

        private GroupList() {
        }

        private void setTreeNode(Element treeNode) {
            this.treeNode = treeNode;
        }

        private int getStartIndex() {
            if (this.treeNode == null) {
                return -1;
            }
            int groupIndex = GroupingList.this.groupLists.indexOfNode(this.treeNode, (byte)1);
            return GroupingList.this.getSourceIndex(groupIndex);
        }

        private int getEndIndex() {
            if (this.treeNode == null) {
                return -1;
            }
            int groupIndex = GroupingList.this.groupLists.indexOfNode(this.treeNode, (byte)1);
            if (groupIndex < GroupingList.this.grouper.getBarcode().blackSize() - 1) {
                return GroupingList.this.grouper.getBarcode().getIndex(groupIndex + 1, Grouper.UNIQUE);
            }
            return GroupingList.this.grouper.getBarcode().size();
        }

        private int getSourceIndex(int index) {
            return this.getStartIndex() + index;
        }

        public Object set(int index, Object element) {
            return GroupingList.this.source.set(this.getSourceIndex(index), element);
        }

        public Object get(int index) {
            return GroupingList.this.source.get(this.getSourceIndex(index));
        }

        public int size() {
            return this.getEndIndex() - this.getStartIndex();
        }

        public void clear() {
            GroupingList.this.source.subList(this.getStartIndex(), this.getEndIndex()).clear();
        }

        public Object remove(int index) {
            return GroupingList.this.source.remove(this.getSourceIndex(index));
        }

        public void add(int index, Object element) {
            GroupingList.this.source.add(this.getSourceIndex(index), element);
        }
    }

    private class GrouperClient
    implements Grouper.Client {
        private GrouperClient() {
        }

        public void groupChanged(int index, int groupIndex, int groupChangeType, boolean primary, int elementChangeType) {
            if (groupChangeType == 2) {
                this.insertGroupList(groupIndex);
                GroupingList.this.updates.addInsert(groupIndex);
            } else if (groupChangeType == 0) {
                this.removeGroupList(groupIndex);
                GroupingList.this.updates.addDelete(groupIndex);
            } else if (groupChangeType == 1) {
                GroupingList.this.updates.addUpdate(groupIndex);
            } else {
                throw new IllegalStateException();
            }
        }

        private void insertGroupList(int index) {
            GroupList groupList = new GroupList();
            Element indexedTreeNode = GroupingList.this.groupLists.add(index, groupList, 1);
            groupList.setTreeNode(indexedTreeNode);
        }

        private void removeGroupList(int index) {
            Element indexedTreeNode = GroupingList.this.groupLists.get(index);
            GroupingList.this.groupLists.remove(indexedTreeNode);
            ((GroupList)indexedTreeNode.get()).setTreeNode(null);
        }
    }
}

