/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel.encryption;

import java.io.IOException;
import org.pdfbox.cos.COSArray;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSInteger;
import org.pdfbox.cos.COSName;
import org.pdfbox.cos.COSNumber;
import org.pdfbox.cos.COSString;

public class PDEncryptionDictionary {
    public static final int VERSION0_UNDOCUMENTED_UNSUPPORTED = 0;
    public static final int VERSION1_40_BIT_ALGORITHM = 1;
    public static final int VERSION2_VARIABLE_LENGTH_ALGORITHM = 2;
    public static final int VERSION3_UNPUBLISHED_ALGORITHM = 3;
    public static final int VERSION4_SECURITY_HANDLER = 4;
    public static final String DEFAULT_NAME = "Standard";
    public static final int DEFAULT_LENGTH = 40;
    public static final int DEFAULT_VERSION = 0;
    protected COSDictionary encryptionDictionary = null;

    public PDEncryptionDictionary() {
        this.encryptionDictionary = new COSDictionary();
    }

    public PDEncryptionDictionary(COSDictionary d) {
        this.encryptionDictionary = d;
    }

    public COSDictionary getCOSDictionary() {
        return this.encryptionDictionary;
    }

    public void setFilter(String filter) {
        this.encryptionDictionary.setItem(COSName.FILTER, (COSBase)COSName.getPDFName(filter));
    }

    public String getFilter() {
        String filter = new String();
        COSName cosFilter = (COSName)this.encryptionDictionary.getDictionaryObject(COSName.FILTER);
        if (cosFilter != null) {
            filter = cosFilter.getName();
        }
        return filter;
    }

    public void setSubFilter(String subfilter) {
        this.encryptionDictionary.setItem(COSName.getPDFName("SubFilter"), (COSBase)COSName.getPDFName(subfilter));
    }

    public void setVersion(int version) {
        this.encryptionDictionary.setItem(COSName.getPDFName("V"), (COSBase)new COSInteger(version));
    }

    public int getVersion() {
        int version = 0;
        COSNumber cosVersion = (COSNumber)this.encryptionDictionary.getDictionaryObject(COSName.getPDFName("V"));
        if (cosVersion != null) {
            version = cosVersion.intValue();
        }
        return version;
    }

    public void setLength(int length) {
        this.encryptionDictionary.setItem(COSName.getPDFName("Length"), (COSBase)new COSInteger(length));
    }

    public int getLength() {
        int length = 40;
        COSNumber cosLength = (COSNumber)this.encryptionDictionary.getDictionaryObject(COSName.LENGTH);
        if (cosLength != null) {
            length = cosLength.intValue();
        }
        return length;
    }

    public void setRevision(int revision) {
        this.encryptionDictionary.setItem(COSName.getPDFName("R"), (COSBase)new COSInteger(revision));
    }

    public int getRevision() {
        int revision = 0;
        COSNumber cosRevision = (COSNumber)this.encryptionDictionary.getDictionaryObject(COSName.getPDFName("R"));
        if (cosRevision != null) {
            revision = cosRevision.intValue();
        }
        return revision;
    }

    public void setOwnerKey(byte[] o) throws IOException {
        COSString owner = new COSString();
        owner.append(o);
        this.encryptionDictionary.setItem(COSName.getPDFName("O"), (COSBase)owner);
    }

    public byte[] getOwnerKey() throws IOException {
        byte[] o = null;
        COSString owner = (COSString)this.encryptionDictionary.getDictionaryObject(COSName.getPDFName("O"));
        if (owner != null) {
            o = owner.getBytes();
        }
        return o;
    }

    public void setUserKey(byte[] u) throws IOException {
        COSString user = new COSString();
        user.append(u);
        this.encryptionDictionary.setItem(COSName.getPDFName("U"), (COSBase)user);
    }

    public byte[] getUserKey() throws IOException {
        byte[] u = null;
        COSString user = (COSString)this.encryptionDictionary.getDictionaryObject(COSName.getPDFName("U"));
        if (user != null) {
            u = user.getBytes();
        }
        return u;
    }

    public void setPermissions(int permissions) {
        this.encryptionDictionary.setItem(COSName.getPDFName("P"), (COSBase)new COSInteger(permissions));
    }

    public int getPermissions() {
        int permissions = 0;
        COSInteger p = (COSInteger)this.encryptionDictionary.getDictionaryObject(COSName.getPDFName("P"));
        if (p != null) {
            permissions = p.intValue();
        }
        return permissions;
    }

    public void setRecipients(byte[][] recipients) throws IOException {
        COSArray array = new COSArray();
        for (int i = 0; i < recipients.length; ++i) {
            COSString recip = new COSString();
            recip.append(recipients[i]);
            recip.setForceLiteralForm(true);
            array.add(recip);
        }
        this.encryptionDictionary.setItem(COSName.getPDFName("Recipients"), (COSBase)array);
    }

    public int getRecipientsLength() throws IOException {
        COSArray array = (COSArray)this.encryptionDictionary.getItem(COSName.getPDFName("Recipients"));
        return array.size();
    }

    public COSString getRecipientStringAt(int i) throws IOException {
        COSArray array = (COSArray)this.encryptionDictionary.getItem(COSName.getPDFName("Recipients"));
        return (COSString)array.get(i);
    }
}

