#!/bin/csh
#
# Copyright (C) 2018 Intel Corporation. All Rights Reserved.
# 
# The source code contained or described herein and all documents
# related to the source code ("Material") are owned by Intel Corporation
# or its suppliers or licensors.  Title to the Material remains with
# Intel Corporation or its suppliers and licensors.  The Material is
# protected by worldwide copyright and trade secret laws and treaty
# provisions.  No part of the Material may be used, copied, reproduced,
# modified, published, uploaded, posted, transmitted, distributed, or
# disclosed in any way without Intel's prior express written permission.
# 
# No license under any patent, copyright, trade secret or other
# intellectual property right is granted to or conferred upon you by
# disclosure or delivery of the Materials, either expressly, by
# implication, inducement, estoppel or otherwise.  Any license under
# such intellectual property rights must be express and approved by
# Intel in writing.

# C Shell script for the Intel(R) Parallel Studio XE 2018 Update 3 for Linux* OS

set SCRIPTPATH=%INSTALLDIR%
set ROOTPATH=%INSTALLDIR_ROOT%
set ITAC_PARAM=""

if ( x"$2" != x"" ) then
    set ITAC_PARAM="$2"
endif

echo "Intel(R) Parallel Studio XE 2018 Update 3 for Linux*"
echo "Copyright (C) 2009-2018 Intel Corporation. All rights reserved."

if ( x"$1" == x"ia32" ) then
    if ( -f "$SCRIPTPATH/compilers_and_libraries_2018/linux/bin/compilervars.csh" ) then
        source "$SCRIPTPATH/compilers_and_libraries_2018/linux/bin/compilervars.csh" "ia32"
    endif
else
    if ( -f "$SCRIPTPATH/compilers_and_libraries_2018/linux/bin/compilervars.csh" ) then
        source "$SCRIPTPATH/compilers_and_libraries_2018/linux/bin/compilervars.csh" "intel64"
    endif
    if ( -f "$SCRIPTPATH/clck_2018/bin/clckvars.csh" ) then
        source "$SCRIPTPATH/clck_2018/bin/clckvars.csh" 
    endif
endif

if ( -f "$SCRIPTPATH/itac_2018/bin/itacvars.csh" ) then
    source "$SCRIPTPATH/itac_2018/bin/itacvars.csh" "$ITAC_PARAM"
endif

if ( -f "$SCRIPTPATH/vtune_amplifier_2018/amplxe-vars.csh" ) then
    source "$SCRIPTPATH/vtune_amplifier_2018/amplxe-vars.csh" quiet
endif

if ( -f "$SCRIPTPATH/inspector_2018/inspxe-vars.csh" ) then
    source "$SCRIPTPATH/inspector_2018/inspxe-vars.csh" quiet
endif

if ( -f "$SCRIPTPATH/advisor_2018/advixe-vars.csh" ) then
    source "$SCRIPTPATH/advisor_2018/advixe-vars.csh" quiet
endif

set path = ($path "$SCRIPTPATH/bin")

if !($?INTEL_LICENSE_FILE) then
    setenv INTEL_LICENSE_FILE "$ROOTPATH/licenses"
else
    setenv INTEL_LICENSE_FILE "$ROOTPATH/licenses:${INTEL_LICENSE_FILE}"
endif
