#!/bin/bash
#
# Copyright (C) 2018 Intel Corporation. All Rights Reserved.
# 
# The source code contained or described herein and all documents
# related to the source code ("Material") are owned by Intel Corporation
# or its suppliers or licensors.  Title to the Material remains with
# Intel Corporation or its suppliers and licensors.  The Material is
# protected by worldwide copyright and trade secret laws and treaty
# provisions.  No part of the Material may be used, copied, reproduced,
# modified, published, uploaded, posted, transmitted, distributed, or
# disclosed in any way without Intel's prior express written permission.
# 
# No license under any patent, copyright, trade secret or other
# intellectual property right is granted to or conferred upon you by
# disclosure or delivery of the Materials, either expressly, by
# implication, inducement, estoppel or otherwise.  Any license under
# such intellectual property rights must be express and approved by
# Intel in writing.

# Bourne Shell script for the Intel(R) Parallel Studio XE 2018 Update 3 for Linux* OS

SCRIPTPATH=%INSTALLDIR%
ROOTPATH=%INSTALLDIR_ROOT%

ITAC_PARAM=""
if [[ -n "$2" ]]; then
    ITAC_PARAM="$2"
fi

echo "Intel(R) Parallel Studio XE 2018 Update 3 for Linux*"
echo "Copyright (C) 2009-2018 Intel Corporation. All rights reserved."

if [ x"$1" = x"ia32" ]; then
    if [[ -f "$SCRIPTPATH/compilers_and_libraries_2018/linux/bin/compilervars.sh" ]]; then
        . "$SCRIPTPATH/compilers_and_libraries_2018/linux/bin/compilervars.sh" "ia32"
    fi
else
    if [[ -f "$SCRIPTPATH/compilers_and_libraries_2018/linux/bin/compilervars.sh" ]]; then
        . "$SCRIPTPATH/compilers_and_libraries_2018/linux/bin/compilervars.sh" "intel64"
    fi

    if [[ -f "$SCRIPTPATH/clck_2018/bin/clckvars.sh" ]]; then
        . "$SCRIPTPATH/clck_2018/bin/clckvars.sh" 
    fi

fi

if [[ -f "$SCRIPTPATH/itac_2018/bin/itacvars.sh" ]]; then
    . "$SCRIPTPATH/itac_2018/bin/itacvars.sh" "$ITAC_PARAM"
fi


if [[ -f "$SCRIPTPATH/inspector_2018/inspxe-vars.sh" ]]; then
    . "$SCRIPTPATH/inspector_2018/inspxe-vars.sh" quiet
fi

if [[ -f "$SCRIPTPATH/vtune_amplifier_2018/amplxe-vars.sh" ]]; then
    . "$SCRIPTPATH/vtune_amplifier_2018/amplxe-vars.sh" quiet
fi

if [[ -f "$SCRIPTPATH/advisor_2018/advixe-vars.sh" ]]; then
    . "$SCRIPTPATH/advisor_2018/advixe-vars.sh" quiet
fi


export PATH="${PATH}:$SCRIPTPATH/bin"

if [ -z "${INTEL_LICENSE_FILE}" ]; then
    export INTEL_LICENSE_FILE="$ROOTPATH/licenses"
else
    export INTEL_LICENSE_FILE="$ROOTPATH/licenses:$INTEL_LICENSE_FILE"
fi
