#!/bin/sh -p
#
# @(#)imqusermgr.sh	1.23 12/01/04
#
# Copyright 2003 Sun Microsystems, Inc. All Rights Reserved
# SUN PROPRIETARY/CONFIDENTIAL
# Use is subject to license terms. 
#
# Message Queue User Manager startup script 
#

# Specify additional arguments to the JVM here
jvm_args=

_bin_home=`/usr/bin/dirname $0`
_init_file="imqinit"

# Source initialization file. This intitializes the imq_* variables
if [ -f $_bin_home/../share/lib/imq/$_init_file ]; then
    # bundled location
    . $_bin_home/../share/lib/imq/$_init_file
elif [ -f $_bin_home/../lib/$_init_file ]; then
    # unbundled location
    . $_bin_home/../lib/$_init_file
elif [ -f $_bin_home/../private/share/lib/$_init_file ]; then
    # Linux "standard" location
    . $_bin_home/../private/share/lib/$_init_file
#####hpux-dev#####
elif [ -f $_bin_home/../private/share/lib/$_init_file ]; then
    # HP-UX "standard" location
    . $_bin_home/../private/share/lib/$_init_file
else
    echo "Error: Could not find required Message Queue initialization file '$_init_file'"
    exit 1
fi

jvm_args="$jvm_args -Dimq.home=$imq_home -Dimq.varhome=$imq_varhome -Dimq.etchome=$imq_etchome -Dimq.libhome=$imq_sharelibimq_home"

_classes=$imq_sharelibimq_home/imqbroker.jar
_mainclass=com.sun.messaging.jmq.jmsserver.auth.usermgr.UserMgr

# Needed to locate libimq
#####hpux-dev#####
PLATFORM=`uname`
if [ "$PLATFORM" = HP-UX ] ; then
SHLIB_PATH=$SHLIB_PATH:$imq_libhome; export SHLIB_PATH
else
LD_LIBRARY_PATH=$LD_LIBRARY_PATH:$imq_libhome; export LD_LIBRARY_PATH
fi


"$imq_javahome/bin/java" -cp $_classes $jvm_args $_mainclass "$@"

