/*
 * @(#)ReferenceGenerator.java	1.5 00/10/05
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */

package com.sun.messaging.naming;

import com.sun.messaging.AdministeredObject;
import java.util.Properties;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import javax.naming.StringRefAddr;
import javax.naming.Reference;

/**
 * A ReferenceGenerator generates a Reference object given an Administered object and
 * the Object Factory Class Name.
 *
 * @version     1.5 00/10/05
 * @author      George Tharakan
 *
 */
public class ReferenceGenerator {

    /** The index in the Reference object of the Version Number */
    public final static int REF_INDEX_VERSION = 0;

    /** The index in the Reference object of the read only state */
    public final static int REF_INDEX_RO_STATE = 1;

    /** The index in the Reference object of the configuration properties */
    public final static int REF_INDEX_PROPERTIES = 2;

    /**
     * Returns the reference to this object.
     *
     * @param ao The AdministeredObject for which the Reference object is to be generated.
     * @param objectfactoryclassname The classname of the ObjectFactory class for ao.
     *
     * @return  The Reference object that can be used to reconstruct this object
     */
    public static Reference getReference(AdministeredObject ao, String objectfactoryclassname) {
    
        //Create a Reference without any addresses
        Reference ref = new Reference(ao.getClass().getName(),
               objectfactoryclassname, null);

        //Set the version number
        ref.add(REF_INDEX_VERSION, new StringRefAddr
            (AdministeredObjectFactory.REF_VERSION, ao.getVERSION()));

        //Set the readOnly state
        ref.add(REF_INDEX_RO_STATE, new StringRefAddr
            (AdministeredObjectFactory.REF_READONLY, String.valueOf(ao.isReadOnly())));

        //Set the configuration
        String sb;
        Properties aoprops = ao.getConfiguration();
        Enumeration ep = aoprops.propertyNames();
        for (int i = REF_INDEX_PROPERTIES; ep.hasMoreElements(); i++) {
            try {
                sb = (String)ep.nextElement();
                ref.add(i, new StringRefAddr(sb, (String)aoprops.get(sb)));
            } catch (NoSuchElementException e) {
                break;
            }
        }
        return ref;
    }
}
