
/*
 * @(#)TransactionInfo.java	1.1 06/01/19
 *
 * Copyright 2006 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */

package com.sun.messaging.jms.management.server;

/**
 * This class contains constants/names for fields in the CompositeData
 * that is returned by the operations of the Transaction Manager Monitor 
 * MBean.
 *
 * @version     1.1 06/01/19
 * @author      Isa Hashim
 */
public class TransactionInfo implements java.io.Serializable  {

    /** 
     * Client ID
     */
    public static final String		CLIENT_ID = "ClientID";

    /** 
     * Object name of Connection
     */
    public static final String		CONNECTION_STRING = "ConnectionString";

    /** 
     * Creation time
     */
    public static final String		CREATION_TIME = "CreationTime";

    /** 
     * Number of acknowledgements
     */
    public static final String		NUM_ACKS = "NumAcks";

    /** 
     * Number of messages
     */
    public static final String		NUM_MSGS = "NumMsgs";

    /** 
     * Transaction state.
     */
    public static final String		STATE = "State";

    /** 
     * String representation of transaction state.
     */
    public static final String		STATE_LABEL = "StateLabel";

    /** 
     * Transaction ID
     */
    public static final String		TRANSACTION_ID = "TransactionID";

    /** 
     * User name
     */
    public static final String		USER = "User";

    /** 
     * XID
     */
    public static final String		XID = "XID";

    /*
     * Class cannot be instantiated
     */
    private TransactionInfo() {
    }
}
