
/*
 * @(#)DestinationType.java	1.3 05/08/08
 *
 * Copyright 2005 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */

package com.sun.messaging.jms.management.server;

/**
 * Class containing information on destination types.
 *
 * @version     1.3 05/08/08
 * @author      Isa Hashim
 */
public class DestinationType {
    /** 
     * Queue destination type
     */
    public static final String QUEUE	= "q";

    /** 
     * Topic destination type
     */
    public static final String TOPIC	= "t";

    /*
     * Class cannot be instantiated
     */
    private DestinationType() {
    }
    
    /**
     * Returns a human readable representation of the specified destination type.
     *
     * @param type Destination type
     * @return String representation of the specified destination type
     */
    public static String toStringLabel(String type)  {

	if (type.equals(QUEUE))  {
	    return("queue");
	} else if (type.equals(TOPIC))  {
	    return("topic");
	} else  {
	    return("unknown");
	}
    }
}
