/*
 * @(#)BadNameValueArgException.java	1.4 00/10/12
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */

package com.sun.messaging.jmq.util.options;

/**
 * This exception is for reporting cases where
 * the argument for an option is not in the format
 * <EM>name=value</EM>. 
 */

public class BadNameValueArgException extends OptionException {

    String	nvArg;

    /**
     * Sets the argument containing the erroneous
     * name/value pair.
     *
     * @param arg	The string argument causing the exception.
     */
    public void setArg(String arg)  {
	this.nvArg = arg;
    }

    /**
     * Returns the string argument causing the error.
     *
     * @return The string argument causing the error
     */
    public String getArg()  {
	return (nvArg);
    }

    public String toString()  {
	return(super.toString() + " (" + getArg() + ")");
    }
}
