/*
 * @(#)DestState.java	1.2 03/09/03
 *
 * Copyright 2002 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */

package com.sun.messaging.jmq.util;


/**
 * State of a destination.
 * <P>
 * <B>XXX</B> How should serialization be handled.
 *
 * @since 3.5
 */

public class DestState 
{
    public static final int UNKNOWN = -1;
    public static final int RUNNING = 0;
    public static final int CONSUMERS_PAUSED = 1;
    public static final int PRODUCERS_PAUSED = 2;
    public static final int PAUSED = 3;

    public static int getStateFromString(String str) {
        if (str.equals("RUNNING")) 
            return RUNNING;
        if (str.equals("CONSUMERS_PAUSED")) 
            return CONSUMERS_PAUSED;
        if (str.equals("PRODUCERS_PAUSED") )
            return PRODUCERS_PAUSED;
        if (str.equals("PAUSED")) 
            return PAUSED;
        return UNKNOWN;
    }


    public static String toString(int state)
    {
        switch (state) {
            case RUNNING:
                return "RUNNING";

            case CONSUMERS_PAUSED:
                return "CONSUMERS_PAUSED";

            case PRODUCERS_PAUSED:
                return "PRODUCERS_PAUSED";

            case PAUSED:
                return "PAUSED";

        }
        return "UNKNOWN";

    }
}
