/*
 * @(#)BrokerExitCode.java	1.3 07/18/02
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */

package com.sun.messaging.jmq.util;

/**
 * This class defines the exit codes the broker uses to indicate
 * exit error condition.
 *
 * Note that 128+signal is used by the JVM (e.g. 129 (SIGHUP),
 * 130 (SIGINT), etc). And the restart logic of the broker checks for
 * 129 (SIGHUP), 130 (SIGINT), 143 (SIGTERM) and 255.
 * When defining new exit codes, avoid overlapping with those.
 * 
 */
public class BrokerExitCode {

    public static final int NORMAL = 0;
    public static final int ERROR = 1;

    // exit codes used to indicate error conditions for
    // the -remove instance option
    public static final int INSTANCE_NOT_EXISTS			= 10;
    public static final int INSTANCE_BEING_USED			= 11;
    public static final int NO_PERMISSION_ON_INSTANCE		= 12;
    public static final int PROBLEM_REMOVING_PERSISTENT_STORE	= 13;
    public static final int IOEXCEPTION				= 14;

    // not to be instantiated
    private BrokerExitCode() {}
}

