/*
 * @(#)JMSAdminFactory.java	1.5 02/04/11
 * 
 * Copyright 2000-2002 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the proprietary information of Sun Microsystems, Inc.
 * Use is subject to license terms.
 * 
 */
package com.sun.messaging.jmq.jmsspi;

import javax.jms.JMSException;

/**
 * Interface definition to return an instance which implements JMSAdmin. 
 */

public interface JMSAdminFactory { 

    /**
     * Create/return an instance implementing JMSAdmin.
     * @return Implementation of JMSAdmin.
     * @exception JMSException thrown if JMSAdmin could not be created/returned.
     */
    JMSAdmin getJMSAdmin() throws JMSException;

    /**
     * Create/return an instance implementing JMSAdmin.
     * @param secure Use secure transport
     * @return Implementation of JMSAdmin.
     * @exception JMSException thrown if JMSAdmin could not be created/returned.
     */
    JMSAdmin getJMSAdmin(boolean secure) throws JMSException;

    /**
     * Create/return an instance implementing JMSAdmin.
     * @param jmsAdminURL JMSAdmin URL
     * @param userName Administrator username
     * @param password Administrator password
     * @return Implementation of JMSAdmin.
     * @exception JMSException thrown if JMSAdmin could not be created/returned.
     */
    JMSAdmin getJMSAdmin(String jmsAdminURL,
                         String userName, String password)
        throws JMSException;

    /**
     * Create/return an instance implementing JMSAdmin.
     * @param jmsAdminURL JMSAdmin URL
     * @param userName Administrator username
     * @param password Administrator password
     * @param secure Use secure transport
     * @return Implementation of JMSAdmin.
     * @exception JMSException thrown if JMSAdmin could not be created/returned.
     */
    JMSAdmin getJMSAdmin(String jmsAdminURL,
                         String userName, String password, boolean secure)
        throws JMSException;

    /**
     * Create/return an instance implementing JMSAdmin.
     * @param jmsAdminURL JMSAdmin URL
     * @return Implementation of JMSAdmin.
     * @exception JMSException thrown if JMSAdmin could not be created/returned.
     */
    JMSAdmin getJMSAdmin(String jmsAdminURL)
        throws JMSException;

    /**
     * Create/return an instance implementing JMSAdmin.
     * @param jmsAdminURL JMSAdmin URL
     * @param secure Use secure transport.
     * @return Implementation of JMSAdmin.
     * @exception JMSException thrown if JMSAdmin could not be created/returned.
     */
    JMSAdmin getJMSAdmin(String jmsAdminURL, boolean secure)
        throws JMSException;

}

