/*
 * @(#)MemoryGlobals.java	1.7 01/31/05
 *
 * Copyright 2002 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */

package com.sun.messaging.jmq.jmsserver.util.memory;

import com.sun.messaging.jmq.jmsserver.Globals;

/** 
 * This class contains globals which are used for memory mgt
 * through out the broker.
 *
 * Individual MemoryLevelHandlers may change the state of these
 * values
 */


public class MemoryGlobals
{

// Variables controled by various memory management levels
    /**
     * automatically free all persistent messages
     * that have been sent but not acknowledged
     */
    public static boolean MEM_FREE_P_ACKED = false;

    /**
     * automatically swap all non-persistent messages
     * that have been sent but not acknowledged
     * (not currently used)
     */
    public static boolean MEM_FREE_NP_ACKED = false;

    /**
     * automatically free all persistent messages
     * that have no active consumers
     */
    public static boolean MEM_FREE_P_NOCON = false;

    /**
     * automatically swap all non-persistent messages
     * that have no active consumers
     * (not currently used)
     */
    public static boolean MEM_FREE_NP_NOCON = false;

    /**
     * automatically free all persistent messages
     */
    public static boolean MEM_FREE_P_ALL = false;

    /**
     * automatically swap all non-persistent messages
     */
    public static boolean MEM_FREE_NP_ALL = false;

    /**
     * no longer allow producers
     */
    public static boolean MEM_DISALLOW_PRODUCERS = false; 

    /**
     * no longer allow new destinations to be created
     */
    public static boolean MEM_DISALLOW_CREATE_DEST = false;


// Properties which control basic memory management behavior

    /**
     * determine whether non-persistent messages should be swapped w/
     * the current persistence implementation or the old swapping code
     */

    public static boolean SWAP_USING_STORE = 
              Globals.getConfig().getBooleanProperty(Globals.IMQ +
                  ".memory_management.swapUsingStore", true);
    public static boolean SWAP_NP_MSGS =
              Globals.getConfig().getBooleanProperty(Globals.IMQ +
                  ".memory_management.swapNPMsgs", true);
    public static boolean KEEP_NP_MSGS_AT_START = 
              Globals.getConfig().getBooleanProperty(Globals.IMQ +
                  ".memory_management.keepNPMsgs", false);


    /**
     * always check memory after a packet is read into the
     * system before processing it
     */
    public static boolean MEM_EXPLICITLY_CHECK = 
              Globals.getConfig().getBooleanProperty(Globals.IMQ +
                  ".memory_management.explicitCheck", false);

    /**
     * always check memory after a packet is read into the
     * system is larger than MEM_SIZE_TO_QUICK_CHECK
     */
    public static boolean MEM_QUICK_CHECK= 
              Globals.getConfig().getBooleanProperty(Globals.IMQ +
                  ".memory_management.quickCheck", false);

    /**
     * Packet size for triggering MEM_QUICK_CHECK
     */
    public static int MEM_SIZE_TO_QUICK_CHECK =
              Globals.getConfig().getIntProperty(Globals.IMQ +
                  ".memory_management.quickCheckSize", 1024*10);

 
    /**
     * automatically free persistent messages at startup
     * after processing (default)
     */
    public static boolean MEM_FREE_AT_RESTART = 
              Globals.getConfig().getBooleanProperty(Globals.IMQ +
                  ".memory_management.freeAutomaticallyAtRestart", true);

}


