
/*
 * @(#)DedicatedService.java	1.18 08/18/05
 *
 * Copyright 2000-2002 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */

package com.sun.messaging.jmq.jmsserver.service.imq.dedicated;

import com.sun.messaging.jmq.util.log.*;
import com.sun.messaging.jmq.io.*;
import com.sun.messaging.jmq.jmsserver.service.imq.*;
import com.sun.messaging.jmq.jmsserver.service.Connection;
import java.nio.channels.*;
import java.io.IOException;
import com.sun.messaging.jmq.util.GoodbyeReason;
import java.util.*;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.resources.*;
import com.sun.messaging.jmq.jmsserver.util.pool.*;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.net.Protocol;
import com.sun.messaging.jmq.jmsserver.net.ProtocolStreams;
import com.sun.messaging.jmq.jmsserver.data.PacketRouter;
import com.sun.messaging.jmq.util.log.Logger;


public class DedicatedService extends IMQService
{

    public DedicatedService(String name, Protocol protocol,
        int type, PacketRouter router, int min, int max) {
        super(name, protocol, type, router, min, max);
    }

    public RunnableFactory getRunnableFactory() {
        return new OperationRunnableFactory(true /* blocking */);
    }

    public Hashtable getDebugState()
    {
//XXX
        return super.getDebugState();
    }


    public void acceptConnection(IMQConnection con)
        throws IOException, BrokerException
    {
        // Get a thread for read

        OperationRunnable read = (OperationRunnable)
                   pool.getAvailRunnable(false);
        OperationRunnable write = (OperationRunnable)
                   pool.getAvailRunnable(false);
        if (read == null || write == null) {
            if (read != null)
                pool.releaseRunnable(read);
            if (write != null)
                pool.releaseRunnable(write);

            String args[] = {this.toString(),
                       String.valueOf(pool.getAssignedCnt()),
                       String.valueOf(pool.getMaximum())};
            logger.log(Logger.WARNING, 
                BrokerResources.E_NOT_ENOUGH_THREADS,
                args);

            pool.debug();
            con.destroyConnection(true, GoodbyeReason.CON_FATAL_ERROR, 
                 Globals.getBrokerResources().getKString(
                 BrokerResources.E_NOT_ENOUGH_THREADS, args));
            throw new BrokerException( 
                Globals.getBrokerResources().getKString(
                    BrokerResources.E_NOT_ENOUGH_THREADS,
                    args),
                BrokerResources.E_NOT_ENOUGH_THREADS,
                (Throwable) null,
                Status.NOT_ALLOWED);

        }

//XXX - workaround to prevent code from breaking when bug 4616064 occurs and
//      provide better output
// XXX

// XXX-start Workaround
        // XXX- workaround for bug (will provide info to track it down)
        boolean assigned = false; 
        while (!assigned) {
            try {
// XXX-end Workaround
                read.assignOperation(con, SelectionKey.OP_READ, 
                                   OperationRunnable.FOREVER);
// XXX-start Workaround
                assigned = true;
            } catch (IllegalAccessException ex) {
                logger.logStack(Logger.ERROR, 
                    BrokerResources.E_INTERNAL_BROKER_ERROR,
                   "assigning read for " + con + " to available thread " 
                   + read, ex);
                pool.debug();
                read = (OperationRunnable)pool.getAvailRunnable(false);
                logger.log(Logger.DEBUG,
                        "Recovering: Assigning new read for " 
                        + con + " to available thread " + read);
                if (read == null) { // bummer
                    String args[] = {this.toString(),
                               String.valueOf(pool.getAssignedCnt()),
                               String.valueOf(pool.getMaximum())};
                    if (write != null)
                        pool.releaseRunnable(write);
                    logger.log(Logger.ERROR, 
                         BrokerResources.E_NOT_ENOUGH_THREADS, args);
                    pool.debug();
                    con.destroyConnection(true, GoodbyeReason.CON_FATAL_ERROR, 
                         Globals.getBrokerResources().getKString(
                         BrokerResources.E_NOT_ENOUGH_THREADS));
                    throw new BrokerException( 
                        Globals.getBrokerResources().getKString(
                            BrokerResources.E_NOT_ENOUGH_THREADS,
                            args),
                        BrokerResources.E_NOT_ENOUGH_THREADS,
                        (Throwable) null,
                        Status.ERROR);
                }
            }
        }
        assigned = false;
        while (!assigned) {
            try {
//XXX-end Workaround
                write.assignOperation(con, SelectionKey.OP_WRITE, 
                                OperationRunnable.FOREVER);
//XXX-start Workaround
                assigned = true;
//XXX-end Workaround
            } catch (IllegalAccessException ex) {
                logger.logStack(Logger.ERROR, 
                    BrokerResources.E_INTERNAL_BROKER_ERROR,
                   "assigning write for " + con 
                   + " to available thread " + read, ex);
                pool.debug();
                write = (OperationRunnable)pool.getAvailRunnable(false);
                logger.log(Logger.DEBUG,
                     "Recovering: Assigning new write for " 
                     + con + " to available thread " + read);
                if (write == null) { // bummer
                    String args[] = {this.toString(),
                               String.valueOf(pool.getAssignedCnt()),
                               String.valueOf(pool.getMaximum())};
                    if (read != null)
                        pool.releaseRunnable(read);
                    logger.log(Logger.ERROR,
                         BrokerResources.E_NOT_ENOUGH_THREADS, args);
                    pool.debug();
                    con.destroyConnection(true, GoodbyeReason.CON_FATAL_ERROR, 
                         Globals.getBrokerResources().getKString(
                         BrokerResources.E_NOT_ENOUGH_THREADS));
                    throw new BrokerException( 
                        Globals.getBrokerResources().getKString(
                            BrokerResources.E_NOT_ENOUGH_THREADS,
                            args),
                        BrokerResources.E_NOT_ENOUGH_THREADS,
                        (Throwable) null,
                        Status.ERROR);
                }
            }
        }
//XXX-end Workaround

    }


}

