/*
 * @(#)HADBDAOFactory.java	1.2 07/22/05
 *
 * Copyright 2004 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */

package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.*;

/**
 * Factory for HADB implementation of DAO object.
 *
 * @version	1.2
 */
public class HADBDAOFactory extends GenericDAOFactory {

    public MessageDAO getMessageDAO() throws BrokerException {

        if ( messageDAO == null ) {
            messageDAO = new HADBMessageDAOImpl();
        }
        return messageDAO;
    }

    public DestinationDAO getDestinationDAO() throws BrokerException {

        if ( destinationDAO == null ) {
            destinationDAO = new HADBDestinationDAOImpl();
        }
        return destinationDAO;
    }

    public ConsumerDAO getConsumerDAO() throws BrokerException {

        if ( consumerDAO == null ) {
            consumerDAO = new HADBConsumerDAOImpl();
        }
        return consumerDAO;
    }

    public ConsumerStateDAO getConsumerStateDAO() throws BrokerException {

        if ( consumerStateDAO == null ) {
            consumerStateDAO = new HADBConsumerStateDAOImpl();
        }
        return consumerStateDAO;
    }

    public ConfigRecordDAO getConfigRecordDAO() throws BrokerException {

        if ( configRecordDAO == null ) {
            configRecordDAO = new HADBConfigRecordDAOImpl();
        }
        return configRecordDAO;
    }

    public TransactionDAO getTransactionDAO() throws BrokerException {

        if ( transactionDAO == null ) {
            transactionDAO = new HADBTransactionDAOImpl();
        }
        return transactionDAO;
    }
}
