/*
 * @(#)DestinationDAO.java	1.6 08/31/05
 *
 * Copyright 2004 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */

package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.core.Destination;

import java.sql.Connection;
import java.util.List;

/**
 * This class is an interface for the Destination table which will be implemented
 * by database specific code.
 *
 * @version	1.6
 */
public interface DestinationDAO extends BaseDAO {

    /**
     * Destination table:
     * Holds all the destination in the system.
     *
     * CREATE TABLE MQDST<schemaVersion>[C<clusterID>|S<brokerID>] (
     *      ID              VARCHAR(100) NOT NULL,
     *      DESTINATION     LONGVARBINARY NOT NULL,
     *      IS_LOCAL        INTEGER NOT NULL,
     *      CONNECTION_ID   BIGINT,
     *      CONNECTED_TS    BIGINT,
     *      BROKER_ID       VARCHAR(100),
     *      CREATED_TS      BIGINT NOT NULL,
     *      PRIMARY KEY(ID)
     * );
     *
     * ID - Unique name of the Destination object
     * DESTINATION - Serialized Destination object
     * IS_LOCAL - Specify whether the destination is local
     * CONNECTION_ID - Connection ID for temporary destination
     * CONNECTED_TS - Timestamp when a temporary destination was created or
     *      when a consumer connected to the destination
     * BROKER_ID - Broker ID associated with the temporary destination
     * CREATED_TS - Timestamp when the entry was created
     */
    public static final String TABLE_NAME_PREFIX = "MQDST" + DBConstants.SCHEMA_VERSION;
    public static final String ID_COLUMN = "ID";
    public static final String DESTINATION_COLUMN = "DESTINATION";
    public static final String IS_LOCAL_COLUMN = "IS_LOCAL";
    public static final String CONNECTION_ID_COLUMN = "CONNECTION_ID";
    public static final String CONNECTED_TS_COLUMN = "CONNECTED_TS";
    public static final String BROKER_ID_COLUMN = "BROKER_ID";
    public static final String CREATED_TS_COLUMN = "CREATED_TS";

    void insert( Connection conn, Destination destination, String brokerID,
        long connectedTime, long createdTime ) throws BrokerException;

    void update( Connection conn, Destination destination )
        throws BrokerException;
    
    void updateConnectedTime( Connection conn, Destination destination,
        long connectedTime ) throws BrokerException;

    void delete( Connection conn, Destination destination )
        throws BrokerException;

    List takeover( Connection conn, String brokerID, String targetBrokerID )
        throws BrokerException;

    List getAllDestinations( Connection conn, String brokerID ) throws BrokerException;

    Destination getDestination( Connection conn, String destName ) throws BrokerException;

    long getDestinationConnectedTime( Connection conn, String destName ) throws BrokerException;

    void checkDestination( Connection conn, String destName ) throws BrokerException;

    boolean hasDestination( Connection conn, String destName ) throws BrokerException;
}
