/*
 * @(#)DAOFactory.java	1.2 05/10/05
 *
 * Copyright 2004 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */

package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.util.log.Logger;

import java.util.List;
import java.util.ArrayList;

/**
 * Factory for DAO object.
 *
 * @version	1.2
 */
public abstract class DAOFactory {

    protected VersionDAO versionDAO = null;
    protected BrokerDAO brokerDAO = null;
    protected PropertyDAO propertyDAO = null;
    protected MessageDAO messageDAO = null;
    protected DestinationDAO destinationDAO = null;
    protected ConsumerDAO consumerDAO = null;
    protected ConsumerStateDAO consumerStateDAO = null;
    protected ConfigRecordDAO configRecordDAO = null;
    protected TransactionDAO transactionDAO = null;
    protected List daoList = null;

    public abstract VersionDAO getVersionDAO() throws BrokerException;

    public abstract BrokerDAO getBrokerDAO() throws BrokerException;

    public abstract PropertyDAO getPropertyDAO() throws BrokerException;

    public abstract MessageDAO getMessageDAO() throws BrokerException;

    public abstract DestinationDAO getDestinationDAO() throws BrokerException;

    public abstract ConsumerDAO getConsumerDAO() throws BrokerException;

    public abstract ConsumerStateDAO getConsumerStateDAO() throws BrokerException;

    public abstract ConfigRecordDAO getConfigRecordDAO() throws BrokerException;

    public abstract TransactionDAO getTransactionDAO() throws BrokerException;

    public List getAllDAOs() throws BrokerException {

        if ( daoList == null ) {
            synchronized( this ) {
                if ( daoList == null ) {
                    ArrayList list = new ArrayList(10);
                    list.add( getVersionDAO() );
                    list.add( getBrokerDAO() );
                    list.add( getPropertyDAO() );
                    list.add( getConfigRecordDAO() );
                    list.add( getConsumerDAO() );
                    list.add( getConsumerStateDAO() );
                    list.add( getDestinationDAO() );
                    list.add( getMessageDAO() );
                    list.add( getTransactionDAO() );
                    daoList = list;
                }
            }
        }

        return daoList;
    }
}
