/*
 * @(#)Protocol.java	1.13 05/02/09
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */

package com.sun.messaging.jmq.jmsserver.net;

import java.util.Hashtable;
import java.io.IOException;
import java.nio.*;
import java.nio.channels.spi.*;
import java.nio.channels.*;
import java.net.*;

/**
 * This interface class handles a specific type of protocol (e.g. tcp)
 */

public interface Protocol 
{
    public void registerProtocolCallback(ProtocolCallback cb, Object data);

    /**
     * The canPause() method is a temporary workaround for bugid
     * 4435336 for jmq2.0 fcs. The TCP and TLS (SSL) transports
     * always return "true". The HTTPProtocol class always returns
     * false.
     */
    public boolean canPause();

    public ProtocolStreams accept()  
        throws IOException;

    public AbstractSelectableChannel getChannel()
        throws IOException;

    public void configureBlocking(boolean blocking)
        throws UnsupportedOperationException,IOException;

    public void open() 
        throws IOException, IllegalStateException;

    public void close() 
        throws IOException, IllegalStateException;

    public boolean isOpen();

    public void checkParameters(Hashtable params)
        throws IllegalArgumentException;

    public void setParameters(Hashtable params)
        throws IOException;

    public int getLocalPort();

    public String getHostName();

    /**
     * method to set the TCP no delay flag on all
     * sockets created if applicable
     */
    public void setNoDelay(boolean val);

    /**
     * method to set the socket timeout (if any)
     * 0 indicates no timeout
     */
    public void setTimeout(int time);

    /**
     * method to set the input buffer size for a connection
     */
    public void setInputBufferSize(int size);

    /**
     * method to set the output buffer size for a connection
     */
    public void setOutputBufferSize(int size);

    /**
     * method to get the input buffer size for a connection
     */
    public int getInputBufferSize();

    /**
     * method to get the output buffer size for a connection
     */
    public int getOutputBufferSize();

    public boolean getBlocking();
}
 

