/*
 * @(#)LockHandler.java	1.2 08/28/03
 *
 * Copyright 2003 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers;

import java.io.*;
import com.sun.messaging.jmq.util.*;
import com.sun.messaging.jmq.jmsserver.util.*;
import com.sun.messaging.jmq.io.*;
import com.sun.messaging.jmq.jmsserver.core.*;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.*;

public class LockHandler extends GPacketHandler {
    public static boolean DEBUG = false;

    public LockHandler(RaptorProtocol p) {
        super(p);
    }

    public void handle(BrokerAddress sender, GPacket pkt) {
        if (DEBUG)
            logger.log(logger.DEBUG, "LockHandler");

        if (pkt.getType() == ProtocolGlobals.G_LOCK) {
            handleLock(sender, pkt);
        }
        else if (pkt.getType() == ProtocolGlobals.G_LOCK_REPLY) {
            handleLockReply(sender, pkt);
        }
        else {
            logger.log(logger.WARNING, "LockHandler " +
                "Internal error : Cannot handle this packet :" +
                pkt.toLongString());
        }
    }

    private void handleLock(BrokerAddress sender, GPacket pkt) {
        String resId;
        long timestamp;
        long xid;
        boolean shared;

        resId = (String) pkt.getProp("I");
        timestamp = ((Long) pkt.getProp("TS")).longValue();
        xid = ((Long) pkt.getProp("X")).longValue();
        shared = ((Boolean) pkt.getProp("SH")).booleanValue();

        p.receiveLockRequest(sender, resId, timestamp, xid, shared);
    }

    private void handleLockReply(BrokerAddress sender, GPacket pkt) {
        String resId;
        long xid;
        int response;

        resId = (String) pkt.getProp("I");
        xid = ((Long) pkt.getProp("X")).longValue();
        response = ((Integer) pkt.getProp("S")).intValue();

        p.receiveLockResponse(sender, resId, xid, response);
    }
}

/*
 * EOF
 */
