/*
 * @(#)ConnectionConfig.java	1.7 02/13/06
 *
 * Copyright 2006 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms. 
 *
 */

package com.sun.messaging.jmq.jmsserver.management.mbeans;

import javax.management.MBeanAttributeInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanNotificationInfo;

import com.sun.messaging.jms.management.server.*;

public class ConnectionConfig extends MQMBeanReadWrite  {
    private long id;

    private static MBeanAttributeInfo[] attrs = {
	    new MBeanAttributeInfo(ConnectionAttributes.CONNECTION_ID,
					String.class.getName(),
					mbr.getString(mbr.I_CXN_ATTR_CXN_ID),
					true,
					false,
					false)
			};

    public ConnectionConfig(long id)  {
	super();
	this.id = id;
    }

    public String getConnectionID()  {
	return (Long.toString(id));
    }

    public String getMBeanName()  {
	return ("ConnectionConfig");
    }

    public String getMBeanDescription()  {
	return (mbr.getString(mbr.I_CXN_CFG_DESC));
    }

    public MBeanAttributeInfo[] getMBeanAttributeInfo()  {
	return (attrs);
    }

    public MBeanOperationInfo[] getMBeanOperationInfo()  {
	return (null);
    }

    public MBeanNotificationInfo[] getMBeanNotificationInfo()  {
	return (null);
    }
}
