/*
 * @(#)TakeoverHandler.java	1.5 08/19/05
 *
 * Copyright 2003 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */

package com.sun.messaging.jmq.jmsserver.data.handlers.admin;

import java.util.Hashtable;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Vector;
import java.util.HashSet;
import java.util.Set;
import java.util.Iterator;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.BrokerStateHandler;
import com.sun.messaging.jmq.jmsserver.cluster.*;
import com.sun.messaging.jmq.jmsserver.cluster.ha.*;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.resources.*;
import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.PacketType;
import com.sun.messaging.jmq.io.Status;
import com.sun.messaging.jmq.util.admin.MessageType;
import com.sun.messaging.jmq.util.log.Logger;

public class TakeoverHandler extends AdminCmdHandler
{
    public TakeoverHandler(AdminDataHandler parent) {
	super(parent);
    }

    /**
     * Handle the incomming administration message.
     *
     * @param con	The Connection the message came in on.
     * @param cmd_msg	The administration message
     * @param cmd_props The properties from the administration message
     */
    public boolean handle(IMQConnection con, Packet cmd_msg,
				       Hashtable cmd_props) {

	if ( DEBUG ) {
            logger.log(Logger.DEBUG, this.getClass().getName() + ": " +
                "Taking over broker: " + cmd_props);
        }

	String brokerID = (String)cmd_props.get(MessageType.JMQ_BROKER_ID);

        int status = Status.OK;
        String errMsg = null;


	/*
	 * Add takeover logic here
	 */

        logger.log(Logger.INFO,
              BrokerResources.I_ADMIN_TAKEOVER,
              brokerID);

	// Send reply
	Packet reply = new Packet(con.useDirectBuffers());
	reply.setPacketType(PacketType.OBJECT_MESSAGE);

        try {
            BrokerStateHandler bsh = Globals.getBrokerStateHandler();
            bsh.takeover(brokerID, true);
        } catch (Exception ex) {
            logger.logStack(Logger.INFO,"L10n-XXX ERROR TAKING OVER BROKER ", ex);
            status = Status.ERROR;
            errMsg =ex.toString();
        }


	setProperties(reply, MessageType.TAKEOVER_BROKER_REPLY, status, errMsg);

	parent.sendReply(con, cmd_msg, reply);

        return true;
    }

}
