/*
 * @(#)DestroyDurableHandler.java	1.17 10/17/05
 *
 * Copyright 2000-2004 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */

package com.sun.messaging.jmq.jmsserver.data.handlers.admin;

import java.util.Hashtable;
import java.io.IOException;
import java.io.*;
import java.util.Vector;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.core.Subscription;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.io.*;
import com.sun.messaging.jmq.util.admin.MessageType;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.jmsserver.Globals;

//XXX:Audit:Removed
//import com.sun.messaging.jmq.jmsserver.audit.MQAuditSession;

public class DestroyDurableHandler extends AdminCmdHandler
{
    public DestroyDurableHandler(AdminDataHandler parent) {
	super(parent);
    }

    /**
     * Handle the incomming administration message.
     *
     * @param con	The Connection the message came in on.
     * @param cmd_msg	The administration message
     * @param cmd_props The properties from the administration message
     */
    public boolean handle(IMQConnection con, Packet cmd_msg,
				       Hashtable cmd_props) {

	if ( DEBUG ) {
            logger.log(Logger.DEBUG, this.getClass().getName() + ": " +
                "DestroyDurable: " + cmd_props);
        }

	String durable = (String)cmd_props.get(MessageType.JMQ_DURABLE_NAME);
	String clientID = (String)cmd_props.get(MessageType.JMQ_CLIENT_ID);

	// Send reply
    	int status = Status.OK;
    	String errMsg = null;

    	try {

//XXX:Audit:Removed
//	    // audit logging for destroy durables
//	    Globals.getAuditSession().durableSubscriberOperation(
//			con.getUserName(), con.remoteHostString(),
//			MQAuditSession.DESTROY_DURABLE, durable, clientID);


            Subscription.unsubscribe(durable, clientID, true);
        } catch (BrokerException ex) {
            errMsg = getMessageFromException(ex);
            status = Status.ERROR;
        }

	Packet reply = new Packet(con.useDirectBuffers());
	reply.setPacketType(PacketType.OBJECT_MESSAGE);

	setProperties(reply, MessageType.DESTROY_DURABLE_REPLY,
		status, errMsg);

	parent.sendReply(con, cmd_msg, reply);
    return true;
    }
}
