/*
 * @(#)StartStopHandler.java	1.29 03/25/05
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */

package com.sun.messaging.jmq.jmsserver.data.handlers;

import java.util.*;
import java.io.*;
import com.sun.messaging.jmq.jmsserver.data.PacketHandler;
import com.sun.messaging.jmq.jmsserver.core.Session;
import com.sun.messaging.jmq.jmsserver.core.SessionUID;
import com.sun.messaging.jmq.io.*;
import com.sun.messaging.jmq.jmsserver.service.Connection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.*;
import com.sun.messaging.jmq.jmsserver.Globals;

import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;


/**
 * Handler class which deals with starting/stoping the delivery of 
 * messages to a specific connection
 */
public class StartStopHandler extends PacketHandler 
{

    Hashtable hash = new Hashtable();

    public StartStopHandler() {
        hash.put("JMQStatus", new Integer(Status.OK));

    }

    /**
     * Method to handle Start and Stop messages
     */
    public boolean handle(IMQConnection con, Packet msg) 
        throws BrokerException
    {
        Hashtable props = null;
        try {
            props = msg.getProperties();
        } catch (Exception ex) {
            throw new RuntimeException("Can not load props", ex);
        }
        Long lsid = (props == null ? null :
             (Long)props.get("JMQSessionID"));

        SessionUID suid = (lsid == null ? null :
              new SessionUID(lsid.longValue()));

        int status = Status.OK;
        String reason = null;

        switch (msg.getPacketType()) {
            case PacketType.START:
                if (suid != null) {
                    boolean bad = false;
                    Session s= Session.getSession(suid);
                    if (!s.getConnectionUID().equals(con.getConnectionUID()))
                        bad = true;
                    assert s != null;
                    // OK .. the client should never be sending us
                    // a bad session ID, but in reconnect it sometimes
                    // does
                    // handle it gracefully if the client does the 
                    // wrong thing
                    if (s == null || bad ) {
                       logger.log(Logger.INFO,"Internal Error: received "
                                 + "bad session id " + suid 
                                 + " when starting session");
                       if (bad) {
                           logger.log(logger.INFO,"Session " + suid +
                              " is bad because "
                             + " it is from a different connection "
                             + " [owning,current]=[" + s.getConnectionUID()
                             + "," + con.getConnectionUID() + "]"); 
                       }
                       status = Status.ERROR;
                       reason = "received bad session id " + s +
                                " when starting session";
                    } else {
                        s.resume("START_STOP");
                    }
                } else {
                    con.startConnection();
                }
                break;
            case PacketType.STOP:
                if (suid != null) {
                    boolean bad = false;
                    Session s= Session.getSession(suid);
                    if (!s.getConnectionUID().equals(con.getConnectionUID()))
                        bad = true;
                    assert s != null;

                    // OK .. the client should never be sending us
                    // a bad session ID, but in reconnect it sometimes
                    // does
                    // handle it gracefully if the client does the 
                    // wrong thing

                    if (s == null || bad) {
                       logger.log(Logger.INFO,"Internal Error: received "
                                 + "bad session id " + suid 
                                 + " when stopping session");
                       if (bad) {
                           logger.log(logger.INFO,"Session " + suid +
                              " is bad because "
                             + " it is from a different connection "
                             + " [owning,current]=[" + s.getConnectionUID()
                             + "," + con.getConnectionUID() + "]"); 
                       }
                       status = Status.ERROR;
                       reason = "received bad session id " + s +  
                                " when stopping session";
                    } else {
                         s.pause("START_STOP");
                    }
                } else {
                    con.stopConnection();
                }
                Packet pkt = new Packet(con.useDirectBuffers());
                pkt.setPacketType(PacketType.STOP_REPLY);
                pkt.setConsumerID(msg.getConsumerID());
                if (con.DUMP_PACKET || con.OUT_DUMP_PACKET)
                    hash.put("JMQReqID", msg.getSysMessageID().toString());

                hash.put("JMQStatus", new Integer(status));
                if (reason != null)
                    hash.put("JMQReason", reason);

                pkt.setProperties(hash);
                con.sendControlMessage(pkt);
                break;
        }
        return true;
    }

}
