/*
 * @(#)GetLicenseHandler.java	1.2 06/30/04
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */

package com.sun.messaging.jmq.jmsserver.data.handlers;

import java.util.*;
import java.net.*;
import com.sun.messaging.jmq.jmsserver.data.PacketHandler;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.io.*;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.license.*;
import com.sun.messaging.jmq.jmsserver.service.Connection;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.service.ConnectionManager;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;


/**
 * Handler class which deals with the GET_LICENSE message
 * GET_LICENSE requests licensing information so the client can restrict
 * licensed features.
 */
public class GetLicenseHandler extends PacketHandler 
{
    private ConnectionManager connectionList;

    private Logger logger = Globals.getLogger();
    private BrokerResources rb = Globals.getBrokerResources();
    public static boolean DEBUG = false;

    private static boolean ALLOW_C_CLIENTS = false;
    private static boolean CAN_RECONNECT = false;

    static {
        try {
            LicenseBase license = Globals.getCurrentLicense(null);
        } catch (BrokerException ex) {
            
        }
        try {
            LicenseBase license = Globals.getCurrentLicense(null);
            CAN_RECONNECT = license.getBooleanProperty(
                                license.PROP_ENABLE_FAILOVER, false);
        } catch (BrokerException ex) {
            CAN_RECONNECT = false;
        }

    }

    public GetLicenseHandler()
    {
    }

    /**
     * Method to handle GET_LICENSE messages
     */
    public boolean handle(IMQConnection con, Packet msg) 
        throws BrokerException 
    { 

         if (DEBUG) {
             logger.log(Logger.DEBUGHIGH, "GetLicenseHandler: handle(" + con + ", " + PacketType.getString(msg.getPacketType()) + ")" );
          }

          String reason = "";
	  int    status = Status.OK;

          // Create reply packet
          Packet pkt = new Packet(con.useDirectBuffers());
          pkt.setPacketType(PacketType.GET_LICENSE_REPLY);
          pkt.setConsumerID(msg.getConsumerID());

          Hashtable hash = new Hashtable();
          try {
              // Added licensing description properties
              LicenseBase license = Globals.getCurrentLicense(null);
              hash.put("JMQLicense",
                  license.getProperty(LicenseBase.PROP_LICENSE_TYPE));
              hash.put("JMQLicenseDesc",
                  license.getProperty(LicenseBase.PROP_DESCRIPTION));

              // Copy license properties into packet
              Properties props = license.getProperties();
              Enumeration e = props.propertyNames();
              while (e.hasMoreElements()) {
                  String key = (String)e.nextElement();
                  hash.put(key, props.get(key));
              }
          } catch (BrokerException ex) {
              // This should never happen, but go ahead and at least
              // capture exception here
              reason = ex.toString();
              status = Status.ERROR;
          }

          hash.put("JMQStatus", new Integer(status));
          if (status != Status.OK) {
              hash.put("JMQReason", reason);
           }

          // Set packet properties
          pkt.setProperties(hash);

          // Send message
	  con.sendControlMessage(pkt);

          return true;
    }

}
