/*
 * @(#)FlowHandler.java	1.15 04/20/05
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */

package com.sun.messaging.jmq.jmsserver.data.handlers;

import java.util.*;
import java.net.*;
import com.sun.messaging.jmq.jmsserver.data.PacketHandler;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.io.*;
import com.sun.messaging.jmq.net.*;
import com.sun.messaging.jmq.jmsserver.service.Connection;
import com.sun.messaging.jmq.jmsserver.service.ConnectionManager;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.auth.AccessController;
import com.sun.messaging.jmq.jmsserver.auth.AuthCacheData;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;



/**
 * handles receiving Flow packet
 */
public class FlowHandler extends PacketHandler 
{

    private Logger logger = Globals.getLogger();
    public static boolean DEBUG = false;


    /**
     * Method to handle flow messages
     */
    public boolean handle(IMQConnection con, Packet msg) 
        throws BrokerException 
    { 

         if (DEBUG) {
             logger.log(Logger.DEBUGHIGH, "FlowHandler: handle() [ Received Flow  Message]");
          }

          assert msg.getPacketType() == PacketType.RESUME_FLOW;


          Hashtable props = null;
          try {
              props = msg.getProperties();
          } catch (Exception ex) {
            logger.log(Logger.INFO,"Internal Error: unable to retrieve "+
                " properties from resume message " + msg, ex);
            props = new Hashtable();
          }

          Integer bufsize = null; 

          Consumer consumer = null;
          if (props != null) {
              bufsize = (Integer)props.get("JMQSize");
              if (bufsize == null) { // try old protocol
                  bufsize = (Integer)props.get("JMQRBufferSize");
              }

              Long cuid = (Long)props.get("JMQConsumerID");
              if (cuid != null) {
                  ConsumerUID tmpuid = new ConsumerUID(cuid.longValue());
                  consumer = Consumer.getConsumer(tmpuid);
              }
          }

          if (DEBUG)
              logger.log(Logger.DEBUG, "Setting JMQRBufferSize -" + bufsize);

          if (consumer != null) {
              // consumer flow control
              try {
                  consumer.resumeFlow(bufsize == null ? -1 : bufsize.intValue());
              } catch (Exception ex) {
                  // only happens if client passs bad bufsize
                  // which is < current size .. this is a protocol
                  // error 
                  logger.logStack(Logger.ERROR,
                      Globals.getBrokerResources().getString(
                          BrokerResources.X_INTERNAL_EXCEPTION,
                           "protocol error, bad rbuf size"), ex);
                  assert false : bufsize;
                  consumer.resumeFlow(-1);
              }
          } else {
              // connection flow control
              con.resumeFlow( bufsize == null ? -1 : bufsize.intValue());
          }
          return true;
 
    }

}
