

/*
 * @(#)ExpirationInfo.java	1.6 07/15/04
 *
 * Copyright 2000-2003 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */


package com.sun.messaging.jmq.jmsserver.core;

import java.util.*;
import com.sun.messaging.jmq.io.SysMessageID;

public class ExpirationInfo 
{
    static Comparator expireCompare = new ExpirationComparator();


    static class ExpirationComparator implements Comparator
    {
        public int compare(Object o1, Object o2) 
        {
            if (o1 instanceof ExpirationInfo &&
                o2 instanceof ExpirationInfo) 
            {
                 ExpirationInfo ei1=(ExpirationInfo)o1;
                 ExpirationInfo ei2=(ExpirationInfo)o2;
                 long dif = ei2.expireTime - ei1.expireTime;
                 if (dif == 0) {
                     SysMessageID sys1 = ei1.id;
                     SysMessageID sys2 = ei2.id;
                     dif = sys2.getTimestamp() - sys1.getTimestamp();
                     if (dif == 0)
                        dif = sys2.getSequence() - sys1.getSequence();
                }

                if (dif < 0) return 1;
                if (dif > 0) return -1;
                return 0;
             }
            assert false;
            return o1.hashCode() - o2.hashCode();
        }

        public int hashCode() {
            return super.hashCode();
        }

        public boolean equals(Object o1) 
        {
            return super.equals(o1);
        }
    }

    SysMessageID id;
    long expireTime;
    boolean expired = false;

    public String toString() {
        return "ExpirationInfo[" + id + "," + expireTime + "]";
    }

    public synchronized boolean isExpired(long time) {
        if (!expired) {
            expired = (expireTime <= time);
         }
         return expired;
    }
    public synchronized boolean isExpired() {
        if (!expired) {
            return isExpired(System.currentTimeMillis());
        }
        return expired;
    }

    public static Comparator getComparator()
    {
        return expireCompare;
    }

    public ExpirationInfo(SysMessageID id, long expireTime)
    {
        this.id = id;
        this.expireTime = expireTime;
    }
    public long getExpireTime() {
        return expireTime;
    }
    public SysMessageID getSysMessageID() {
        return id;
    }

    public int hashCode() {
        return id.hashCode();
    }
    public boolean equals(Object o) {
        if (!(o instanceof ExpirationInfo)) {
            return false;
        }
        ExpirationInfo ei = (ExpirationInfo)o;
        assert id != null && ei != null && ei.id != null;
        return id.equals(ei.id);
    }
}

