/*
 * @(#)UserInfo.java	1.3 00/10/18
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */
/*
 * @author Shivaram Mysore
 * @version 1.3 00/10/18
 *
 */

package com.sun.messaging.jmq.jmsserver.auth.usermgr;

public class UserInfo {
    public final static String ROLE_ANON		= "anonymous";
    public final static String ROLE_USER		= "user";
    public final static String ROLE_ADMIN		= "admin";

    public final static String DEFAULT_ADMIN_USERNAME	= "admin";
    public final static String DEFAULT_ADMIN_PASSWD	= "admin";

    public final static String DEFAULT_ANON_USERNAME	= "guest";
    public final static String DEFAULT_ANON_PASSWD	= "guest";
    
    String	user = null,
    		passwd = null,
    		role = null;
    boolean	active = true;

    public UserInfo(String user, String passwd) {
        this(user, passwd, "user", true);
    }

    public UserInfo(String user, String passwd, String role) {
        this(user, passwd, role, true);
    }

    public UserInfo(String user, String passwd, String role, boolean active) {
        this.user = user;
        this.passwd = passwd;
        this.role = role;
        this.active = active;
    }

    public String getUser() {
        return user;
    }

    public String getPasswd() {
        return passwd;
    }

    public String getRole() {
        return role;
    }

    public boolean isActive()  {
	return active;
    }

    public String getPasswdEntry()  {
        return (user
		+ ":" 
		+ passwd
		+ ":"
		+ role
		+ ":"
		+ (active ? "1" : "0"));
    }

    public String toString() {
        return (getPasswdEntry());
    }
}

