/*
 * @(#)CallbackHandlerImpl.java	1.1 05/04/24
 *
 * Copyright 2005 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */

package com.sun.messaging.jmq.jmsserver.auth.jaas;

import java.util.Properties;
import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.LanguageCallback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.TextOutputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.auth.AccessController;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;

/**
 */

public class CallbackHandlerImpl implements CallbackHandler {

    public static boolean DEBUG = false;

    private BrokerResources rb = Globals.getBrokerResources();
    private transient Logger logger = Globals.getLogger();

    private Properties authProps = null;
    private String userName = null;
    private String password = null;

    /**
     * not used as default handler
     */
    private CallbackHandlerImpl() { }

    public CallbackHandlerImpl(Properties authProps, String userName, String password) {
        this.authProps = authProps;
        this.userName = userName;
        this.password = password;
    }

    protected synchronized void destroy() {
        authProps = null;
        userName = null;
        password = null;
    }

    /**
     * Handles the specified set of callbacks.
     *
     * @param callbacks An array of Callback objects provided by an 
     *                  underlying security service which contains the
     *                  information requested to be retrieved or displayed.
     * @throws IOException If an input or output error occurs 
     * @throws UnsupportedCallbackException If the implementation of this 
     *         method does not support one or more of the Callbacks specified
     *         in the callbacks parameter.
     */
    public synchronized void handle(Callback[] callbacks) throws IOException, 
                                                UnsupportedCallbackException {

	    for (int i = 0; i < callbacks.length; i++) {

	    if (callbacks[i] instanceof LanguageCallback) {
            LanguageCallback cb = (LanguageCallback)callbacks[i];
            if (DEBUG) {
                logger.log(logger.INFO, "JAAS CallbackHander handle LanguageCallback -"+
                           " returning " + rb.getLocale());
            }
            cb.setLocale(rb.getLocale());
            continue;
        } 
        if (callbacks[i] instanceof NameCallback) {
            if (userName == null) { 
                logger.log(logger.ERROR, "XXXJAAS callback handler not initialized");
                throw new UnsupportedCallbackException(callbacks[i], "XXXNot initialized");
            }
            NameCallback cb = (NameCallback)callbacks[i];
            if (DEBUG) {
                logger.log(logger.INFO, "JAAS CallbackHander handle NameCallback prompt: "+
                       ((NameCallback)callbacks[i]).getPrompt()+ " - returning " +userName);
            }
            cb.setName(userName);
            continue;
        }
 	    if (callbacks[i] instanceof PasswordCallback) {
            if (password == null) { 
                logger.log(logger.ERROR, "XXXJAAS callback handler not initialized");
                throw new UnsupportedCallbackException(callbacks[i], "XXXNot initialized");
            }

 		    PasswordCallback cb = (PasswordCallback)callbacks[i];
            if (DEBUG) {
                logger.log(logger.INFO, 
           "JAAS CallbackHander handle PasswordCallback ["+cb.getClass().getName()+"] prompt:"+cb.getPrompt());
            }
 		    cb.setPassword(password.toCharArray());
            continue;
        }
        if (callbacks[i] instanceof TextInputCallback) {
            if (authProps == null) { 
                logger.log(logger.ERROR, "XXXJAAS callback handler not initialized");
                throw new UnsupportedCallbackException(callbacks[i], "XXXNot initialized");
            }

            TextInputCallback cb = (TextInputCallback)callbacks[i];
            String text =  null;
            if (cb.getPrompt().equals(AccessController.PROP_AUTHENTICATION_TYPE)) {
                text = (String)authProps.getProperty(AccessController.PROP_AUTHENTICATION_TYPE); 
            } else if (cb.getPrompt().equals(AccessController.PROP_ACCESSCONTROL_TYPE)) {
                text = (String)authProps.getProperty(AccessController.PROP_ACCESSCONTROL_TYPE); 
            } else { 
                logger.log(logger.WARNING, 
                "XXX Unsupported JAAS TextInputCallback ["+cb.getClass().getName()+"] with promt "+
                                            cb.getPrompt());
                throw new UnsupportedCallbackException(callbacks[i], "TextInputCallback:"+ cb.getPrompt());
            }
            if (DEBUG) {
                logger.log(logger.INFO, "JAAS CallbackHander handle TextInputCallback prompt: "+
                       ((TextInputCallback)callbacks[i]).getPrompt()+ " - returning " +text);
            }
            cb.setText(text);
            continue; 
        }
        if (callbacks[i] instanceof TextOutputCallback) {
		    int level = logger.OFF;
            TextOutputCallback cb = (TextOutputCallback) callbacks[i];

            switch (cb.getMessageType()) {
            case TextOutputCallback.INFORMATION:
                 level = logger.INFO;
                 break;
            case TextOutputCallback.WARNING:
                 level = logger.WARNING;
                 break;
            case TextOutputCallback.ERROR:
                 level = logger.ERROR;
                 break;
            default:
                logger.log(logger.WARNING, 
                "XXX Unsupported JAAS TextOutputCallback ["+cb.getClass().getName()+"] with message type "+
                                            cb.getMessageType());
                throw new UnsupportedCallbackException(callbacks[i], "TextOutputCallback with message type "+ 
                                            cb.getMessageType());
		    }
            logger.log(level, cb.getClass().getName()+": "+ cb.getMessage());
	        continue;	
        }

 		throw new UnsupportedCallbackException(callbacks[i], "Unsupported Callback");
        } //for
	}
	    
}
