/*
 * @(#)Compressor.java	1.1 04/05/18
 *
 * Copyright 2004 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */

package com.sun.messaging.jmq.jmsclient.zip;

import java.util.zip.*;
import java.io.*;

import com.sun.messaging.jmq.jmsclient.Debug;

public class Compressor {

    private Deflater deflater = new Deflater();

    //private Deflater noWrapDeflater = new Deflater (Deflater.DEFAULT_COMPRESSION, true);

    private static Compressor compressor = new Compressor();

    private boolean debug = Boolean.getBoolean("imq.zip.debug");

    private Compressor () {
    }

    public static Compressor getInstance() {
        return compressor;
    }

    public synchronized int
    compress (byte[] body, int offset, int length, OutputStream os) throws IOException {

        int compressedLength = -1;

        Deflater def = getDefaultDeflater();

        DeflaterOutputStream defos = new DeflaterOutputStream(os, def);

        defos.write(body, offset, length);

        defos.finish();

        int totalIn = def.getTotalIn();
        compressedLength = def.getTotalOut();

        if (debug) {
            Debug.getPrintStream().println
                ("**** compressor total in: " + totalIn);

            Debug.getPrintStream().println
                ("**** compressor total out: " + compressedLength);
        }

        def.reset();

        return compressedLength;
    }

    private Deflater getDeflater(boolean noWrap, int strategy, int level) {

        Deflater def = null;

        if ( noWrap ) {
            //def = noWrapDeflater;
            throw new RuntimeException ("No wrap deflater is not Unsupported.");
        } else {
            def = deflater;
        }

        def.setStrategy( strategy );

        def.setLevel( level );

        return def;
    }

    private Deflater getDefaultDeflater() {
        return getDeflater (false, Deflater.DEFAULT_STRATEGY, Deflater.DEFAULT_COMPRESSION);
    }
}
