/*
 * @(#)JMQAdminKeyAuthenticationHandler.java	1.3 05/11/09
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */
package com.sun.messaging.jmq.jmsclient.auth;

import java.io.*;
import java.util.Hashtable;
import javax.security.auth.login.LoginException;
import com.sun.messaging.AdministeredObject;
import com.sun.messaging.jmq.auth.api.client.*;
import com.sun.messaging.jmq.util.BASE64Encoder;

/**
 * JMQ AdminKey authentication request handler
 * authType:        jmqadminkey 
 */

public final class JMQAdminKeyAuthenticationHandler implements AuthenticationProtocolHandler {

    private String username = null;
    private String password = null;

    public String getType() {
        return "jmqadminkey";
    }

    /**
     * This method is called right before start a authentication process
     * Currently for JMQ2.0, username/password always have values (if not
     * passed in createConnection() call, they are assigned default values).
     */
    public void init(String username, String password,
                     Hashtable authProperties) throws LoginException {
        this.username = username;
        this.password = password;
    }

    public byte[] handleRequest(byte[] authRequest, int sequence) 
                                throws LoginException {
        if (username == null || password == null) {
            String errorString = AdministeredObject.cr.getKString(
                        AdministeredObject.cr.X_NO_USERNAME_PASSWORD);
            throw new LoginException(errorString);
        }

        try {

        byte[] response;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);

        dos.writeUTF(username); 

        BASE64Encoder encoder = new BASE64Encoder();
        String encodepass = encoder.encode(password.getBytes("UTF8"));
        dos.writeUTF(encodepass);
        dos.flush();
        response = bos.toByteArray();
        dos.close();
        return response;

        } catch (IOException e) {
        throw new LoginException("IOException: "+e.getMessage());  
        }
    }
}
