/*
 * @(#)TopicSessionImpl.java	1.24 04/05/14
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */

package com.sun.messaging.jmq.jmsclient;

import javax.jms.*;

import com.sun.messaging.AdministeredObject;

/** A TopicSession provides methods for creating TopicPublisher's,
  * TopicSubscriber's and TemporaryTopics. It also provides a method for
  * deleting its client's durable subscribers.
  *
  * @version     1.0 - 4 August 1998
  * @author      Mark Hapner
  * @author      Rich Burridge
  *
  * @see         javax.jms.Session
  * @see	 javax.jms.TopicConnection#createTopicSession(boolean, int)
  * @see         javax.jms.XATopicSession#getTopicSession()
  */

public class TopicSessionImpl extends UnifiedSessionImpl implements TopicSession {

    public TopicSessionImpl (ConnectionImpl connection, boolean transacted, int ackMode) throws JMSException {
        super (connection, transacted, ackMode);
    }

    public TopicSessionImpl (ConnectionImpl connection, int ackMode)
        throws JMSException {
        super (connection, ackMode);
    }

    /**
    * Throws an IllegalStateException as it is an invalid method for this domain.
    *
    * @param queueName the name of this queue
    *
    * @return a Queue with the given name.
    *
    * @exception IllegalStateException Always, since it is an invalid method for
    *            this domain.
    */
    public Queue createQueue(String queueName) throws JMSException {

        String errorString = AdministeredObject.cr.getKString(AdministeredObject.cr.X_ILLEGAL_METHOD_FOR_DOMAIN,
                                                              "createQueue");
        throw new javax.jms.IllegalStateException(errorString, AdministeredObject.cr.X_ILLEGAL_METHOD_FOR_DOMAIN);
    }

    /**
    * Throws an IllegalStateException as it is an invalid method for this domain.
    *
    * @return a temporary queue identity
    *
    * @exception IllegalStateException Always, since it is an invalid method for
    *            this domain.
    */
    public TemporaryQueue
    createTemporaryQueue() throws JMSException {

        String errorString = AdministeredObject.cr.getKString(AdministeredObject.cr.X_ILLEGAL_METHOD_FOR_DOMAIN,
                                                              "createTemporaryQueue");
        throw new javax.jms.IllegalStateException(errorString, AdministeredObject.cr.X_ILLEGAL_METHOD_FOR_DOMAIN);
    }

    /**
    * Throws an IllegalStateException as it is an invalid method for this domain.
    *
    * @param queue the queue to access
    *
    * @exception IllegalStateException Always, since it is an invalid method for
    *            this domain.
    */
    public QueueBrowser
    createBrowser(Queue queue) throws JMSException {

        String errorString = AdministeredObject.cr.getKString(AdministeredObject.cr.X_ILLEGAL_METHOD_FOR_DOMAIN,
                                                              "createBrowser");
        throw new javax.jms.IllegalStateException(errorString, AdministeredObject.cr.X_ILLEGAL_METHOD_FOR_DOMAIN);
    }

    /**
    * Throws an IllegalStateException as it is an invalid method for this domain.
    *
    * @param queue the queue to access
    * @param selector the selector to use
    *
    * @exception IllegalStateException Always, since it is an invalid method for
    *            this domain.
    */
    public QueueBrowser
    createBrowser(Queue queue, String selector) throws JMSException {
        String errorString = AdministeredObject.cr.getKString(AdministeredObject.cr.X_ILLEGAL_METHOD_FOR_DOMAIN,
                                                              "createBrowser");
        throw new javax.jms.IllegalStateException(errorString, AdministeredObject.cr.X_ILLEGAL_METHOD_FOR_DOMAIN);
    }
}
