/*
 * @(#)TopicConnectionImpl.java	1.20 04/05/14
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */

package com.sun.messaging.jmq.jmsclient;

import javax.jms.*;
import java.util.Properties;

/**
 * A TopicConnection is an active connection to a JMS Pub/Sub provider.
 * A client uses a TopicConnection to create one or more TopicSessions
 * for producing and consuming messages.
 *
 * @version     1.20 04/05/14
 *
 * @see javax.jms.Connection
 * @see javax.jms.TopicConnectionFactory
 */
public class TopicConnectionImpl extends UnifiedConnectionImpl implements com.sun.messaging.jms.TopicConnection {

    public
    TopicConnectionImpl(Properties configuration, String username,
                        String password, String type) throws JMSException {
        super(configuration, username, password, type);
        setIsTopicConnection(true);
    }

    public TopicSession
    createTopicSession(int acknowledgeMode) throws JMSException {
        checkConnectionState();

        TopicSessionImpl ts = new TopicSessionImpl (this, acknowledgeMode);

        //disallow to set client ID after this action.
        setClientIDFlag();

        return ( ts );
    }

}
