/*
 * @(#)JMSXAWrappedConnectionFactoryImpl.java	1.1 02/03/27
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */

package com.sun.messaging.jmq.jmsclient;

import com.sun.jms.spi.xa.*;
import javax.jms.*;
import java.io.Serializable;

/**
 * An <code>XAQueueConnectionFactory</code> is used to create XAQueueConnections with
 * a Java Message Service (JMS) Point-to-Point (PTP) provider.
 *
 * @version 1.1 02/03/27
 * @author  George Tharakan
 *
 * @see         javax.jms.XAQueueConnectionFactory javax.jms.XAQueueConnectionFactory
 */
public class JMSXAWrappedConnectionFactoryImpl implements JMSXAQueueConnectionFactory, JMSXATopicConnectionFactory, Serializable {

    private ConnectionFactory wrapped_connectionfactory;
    public static boolean debug = Boolean.getBoolean("DEBUG_JMSXAWrappedForExternalJMS"); 

    /** private constuctor - disallow null constructor */
    private JMSXAWrappedConnectionFactoryImpl() {}
     
    /**
     * Constructs a JMSXAWrappedConnectionFactoryImpl using an standard JMS
     *              XAQueueConnectionFactory.
     * 
     */
    public JMSXAWrappedConnectionFactoryImpl(XAQueueConnectionFactory xaqcf) {
        wrapped_connectionfactory = xaqcf;
    }
 
    /**
     * Constructs a JMSXAWrappedConnectionFactoryImpl using an standard JMS
     *              XATopicConnectionFactory.
     * 
     */
    public JMSXAWrappedConnectionFactoryImpl(XATopicConnectionFactory xatcf) {
        wrapped_connectionfactory = xatcf;
    }
 
    /**
     * Constructs a JMSXAWrappedConnectionFactoryImpl using an standard JMS
     *              QueueConnectionFactory.
     * 
     */
    public JMSXAWrappedConnectionFactoryImpl(QueueConnectionFactory qcf) {
        wrapped_connectionfactory = qcf;
    }
 
    /**
     * Constructs a JMSXAWrappedConnectionFactoryImpl using an standard JMS
     *              TopicConnectionFactory.
     * 
     */
    public JMSXAWrappedConnectionFactoryImpl(TopicConnectionFactory tcf) {
        wrapped_connectionfactory = tcf;
    }
 
    /**
     * Create an XA queue connection with default user identity.
     * The connection is created in stopped mode. No messages
     * will be delivered until <code>Connection.start</code> method
     * is explicitly called.
     *  
     * @return a newly created XA queue connection.
     *  
     * @exception JMSException if JMS Provider fails to create XA queue Connection
     *                         due to some internal error.
     * @exception JMSSecurityException  if client authentication fails due to
     *                         invalid user name or password.
     */
    public JMSXAQueueConnection createXAQueueConnection() throws JMSException {
        if (wrapped_connectionfactory instanceof XAConnectionFactory) {
            return (JMSXAQueueConnection) (new JMSXAWrappedQueueConnectionImpl(
                ((XAQueueConnectionFactory)wrapped_connectionfactory).createXAQueueConnection(), this, null, null));
        } else {
            //wrapped_connectionfactory cannot be anything than a javax.jms.ConnectionFactory at this point
            return (JMSXAQueueConnection) (new JMSXAWrappedQueueConnectionImpl(
                    ((QueueConnectionFactory)wrapped_connectionfactory).createQueueConnection(), this, null, null));
        }
    }

    /**
     * Create an XA queue connection with specific user identity.
     * The connection is created in stopped mode. No messages
     * will be delivered until <code>Connection.start</code> method
     * is explicitly called.
     *  
     * @param username the caller's user name
     * @param password the caller's password
     *
     * @return a newly created XA queue connection.
     *
     * @exception JMSException if JMS Provider fails to create XA queue Connection
     *                         due to some internal error.
     * @exception JMSSecurityException  if client authentication fails due to
     *                         invalid user name or password.
     */
    public JMSXAQueueConnection createXAQueueConnection(String username,
                                                        String password) throws JMSException {
        if (wrapped_connectionfactory instanceof XAConnectionFactory) {
            return (JMSXAQueueConnection) (new JMSXAWrappedQueueConnectionImpl(
                ((XAQueueConnectionFactory)
                  wrapped_connectionfactory).createXAQueueConnection(username, password),
                 this, username, password));
        } else {
            //wrapped_connectionfactory cannot be anything than a javax.jms.ConnectionFactory at this point
            return (JMSXAQueueConnection) (new JMSXAWrappedQueueConnectionImpl(
                    ((QueueConnectionFactory)wrapped_connectionfactory).createQueueConnection(username, password),
                     this, username, password));
        }
    }

    /**
     * Create an XA topic connection with default user identity.
     * The connection is created in stopped mode. No messages
     * will be delivered until <code>Connection.start</code> method
     * is explicitly called.
     *  
     * @return a newly created XA topic connection.
     *  
     * @exception JMSException if JMS Provider fails to create XA topic Connection
     *                         due to some internal error.
     * @exception JMSSecurityException  if client authentication fails due to
     *                         invalid user name or password.
     */
    public JMSXATopicConnection createXATopicConnection() throws JMSException {
        if (wrapped_connectionfactory instanceof XAConnectionFactory) {
            return (JMSXATopicConnection) (new JMSXAWrappedTopicConnectionImpl(
                ((XATopicConnectionFactory)wrapped_connectionfactory).createXATopicConnection(), this, null, null));
        } else {
            //wrapped_connectionfactory cannot be anything than a javax.jms.ConnectionFactory at this point
            return (JMSXATopicConnection) (new JMSXAWrappedTopicConnectionImpl(
                    ((TopicConnectionFactory)wrapped_connectionfactory).createTopicConnection(), this, null, null));
        }
    }

    /**
     * Create an XA topic connection with specific user identity.
     * The connection is created in stopped mode. No messages
     * will be delivered until <code>Connection.start</code> method
     * is explicitly called.
     *  
     * @param username the caller's user name
     * @param password the caller's password
     *
     * @return a newly created XA topic connection.
     *
     * @exception JMSException if JMS Provider fails to create XA topic Connection
     *                         due to some internal error.
     * @exception JMSSecurityException  if client authentication fails due to
     *                         invalid user name or password.
     */
    public JMSXATopicConnection createXATopicConnection(String username,
                                                        String password) throws JMSException {
        if (wrapped_connectionfactory instanceof XAConnectionFactory) {
            return (JMSXATopicConnection) (new JMSXAWrappedTopicConnectionImpl(
                ((XATopicConnectionFactory)
                  wrapped_connectionfactory).createXATopicConnection(username, password),
                 this, username, password));
        } else {
            //wrapped_connectionfactory cannot be anything than a javax.jms.ConnectionFactory at this point
            return (JMSXATopicConnection) (new JMSXAWrappedTopicConnectionImpl(
                    ((TopicConnectionFactory)wrapped_connectionfactory).createTopicConnection(username, password),
                     this, username, password));
        }
    }
}

