/*
 * @(#)VRFileWarning.java	1.1 07/29/03
 *
 * Copyright 2003 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */

package com.sun.messaging.jmq.io;

import java.util.ArrayList;

/**
 * This class provides information about problems and
 * data corruptions encountered when loading the backing file.
 */

public class VRFileWarning extends Throwable {

    private ArrayList warnings = new ArrayList(1);

    /**
     * Constructs a VRFileWarning
     */ 
    public VRFileWarning() {
        super();
    }

    /** 
     * Constructs a VRFileWarning with a reason
     *
     * @param  reason        a description of the exception
     **/
    public VRFileWarning(String reason) {
        super(reason);
    }

    /**
     * Gets all warnings.
     *
     * @return all warnings
     **/
    public String[] getWarnings() {
        return (String[])warnings.toArray(new String[0]);
    }

    /**
     * Add a warning.
     * @param w       a warning
     **/
    public synchronized void addWarning(String w) {
        warnings.add(w);
    }

    public String toString() {
	return super.toString() + ":" + warnings;
    }
}
