/*
 * @(#)BrokerConstants.java	1.27 06/01/10
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */

package com.sun.messaging.jmq.admin.bkrutil;

/**
 * Interface containing constants related to broker administration.
 *
 * This currently holds property names that are shared/common across
 * all broker admin tools.
 *
 * @version	1.27 06/01/10
 */
public interface BrokerConstants  {

    /*
     * Property names for broker attributes
     *
     */
    public static String PROP_NAME_BKR_INSTANCE_NAME	= "imq.instancename";
    public static String PROP_NAME_BKR_PRIMARY_PORT	= "imq.portmapper.port";
    public static String PROP_NAME_BKR_AUTOCREATE_TOPIC	= "imq.autocreate.topic";
    public static String PROP_NAME_BKR_AUTOCREATE_QUEUE	= "imq.autocreate.queue";
    public static String PROP_NAME_BKR_QUEUE_DELIVERY_POLICY= "imq.queue.deliverypolicy";
    public static String PROP_NAME_BKR_LOG_LEVEL	= "imq.log.level";
    public static String PROP_NAME_BKR_LOG_ROLL_SIZE	= "imq.log.file.rolloverbytes";
    public static String PROP_NAME_BKR_LOG_ROLL_INTERVAL= "imq.log.file.rolloversecs";
    /*
    public static String PROP_NAME_BKR_METRIC_INTERVAL	= "imq.metrics.interval";
    */
    public static String PROP_NAME_BKR_MAX_MSG		= "imq.system.max_count";
    public static String PROP_NAME_BKR_MAX_TTL_MSG_BYTES= "imq.system.max_size";
    public static String PROP_NAME_BKR_MAX_MSG_BYTES	= "imq.message.max_size";

    public static String PROP_NAME_BKR_CUR_MSG		= "imq.system.current_count";
    public static String PROP_NAME_BKR_CUR_TTL_MSG_BYTES= "imq.system.current_size";

    public static String PROP_NAME_BKR_CLS_BKRLIST	= "imq.cluster.brokerlist";
    public static String PROP_NAME_BKR_CLS_BKRLIST_ACTIVE= "imq.cluster.brokerlist.active";
    public static String PROP_NAME_BKR_CLS_CFG_SVR	= "imq.cluster.masterbroker";
    public static String PROP_NAME_BKR_CLS_URL		= "imq.cluster.url";
    public static String PROP_NAME_BKR_CLS_CLUSTER_ID	= "imq.cluster.clusterid";
    public static String PROP_NAME_BKR_CLS_BROKER_ID	= "imq.brokerid";
    public static String PROP_NAME_BKR_PRODUCT_VERSION	= "imq.product.version";
    public static String PROP_NAME_BKR_AUTOCREATE_QUEUE_MAX_ACTIVE_CONS
					= "imq.autocreate.queue.maxNumActiveConsumers";
    public static String PROP_NAME_BKR_AUTOCREATE_QUEUE_MAX_BACKUP_CONS
					= "imq.autocreate.queue.maxNumBackupConsumers";
    public static String PROP_NAME_BKR_LOG_DEAD_MSGS
					= "imq.destination.logDeadMsgs";
    public static String PROP_NAME_BKR_DMQ_TRUNCATE_MSG_BODY
					= "imq.destination.DMQ.truncateBody";
    public static String PROP_NAME_BKR_IS_EMBEDDED= "imq.embedded";
    public static String PROP_NAME_BKR_VARHOME		= "imq.varhome";
    public static String PROP_NAME_BKR_LICENSE_DESC	= "imq.license.description";
    public static String PROP_NAME_DMQ_CUR_MSG		= "imq.dmq.current_count";
    public static String PROP_NAME_DMQ_CUR_TTL_MSG_BYTES= "imq.dmq.current_size";

    /*
     * Property names returned in Hashtables for GET_TRANSACTION admin message
     */
    public static String PROP_NAME_TXN_ID		= "txnid";
    public static String PROP_NAME_TXN_XID		= "xid";
    public static String PROP_NAME_TXN_NUM_MSGS		= "nmsgs";
    public static String PROP_NAME_TXN_NUM_ACKS		= "nacks";
    public static String PROP_NAME_TXN_USER		= "user";
    public static String PROP_NAME_TXN_CLIENTID		= "clientid";
    public static String PROP_NAME_TXN_TIMESTAMP	= "timestamp";
    public static String PROP_NAME_TXN_CONNECTION	= "connection";
    public static String PROP_NAME_TXN_STATE		= "state";

    /*
     * Property names returned in Hashtables in GET_CONNECTIONS admin message
     */
    public static String PROP_NAME_CXN_CXN_ID		= "cxnid";
    public static String PROP_NAME_CXN_CLIENT_ID	= "clientid";
    public static String PROP_NAME_CXN_HOST		= "host";
    public static String PROP_NAME_CXN_PORT		= "port";
    public static String PROP_NAME_CXN_USER		= "user";
    public static String PROP_NAME_CXN_NUM_PRODUCER	= "nproducers";
    public static String PROP_NAME_CXN_NUM_CONSUMER	= "nconsumers";
    public static String PROP_NAME_CXN_CLIENT_PLATFORM	= "clientplatform";
    public static String PROP_NAME_CXN_SERVICE		= "service";

    /*
     * Property names returned in Hashtables in GET_JMX admin message
     */
    public static String PROP_NAME_JMX_NAME		= "name";
    public static String PROP_NAME_JMX_ACTIVE		= "active";
    public static String PROP_NAME_JMX_URL		= "url";

    /*
     * Valid values for broker log level.
     */
    public static String[] BKR_LOG_LEVEL_VALID_VALUES	= {
					    "NONE",
					    "ERROR",
					    "WARNING",
					    "INFO"
						};

    /*
     * Queue flavour property names, as expected by the broker
     */
    public static String PROP_NAME_QUEUE_FLAVOUR_SINGLE         = "single";
    public static String PROP_NAME_QUEUE_FLAVOUR_FAILOVER       = "failover";
    public static String PROP_NAME_QUEUE_FLAVOUR_ROUNDROBIN     = "round-robin";

    /*
     * Valid values for broker log level.
     * Note: Indices for the strings below need to match the
     * array contents.
     */
    public static String[] BKR_LIMIT_BEHAV_VALID_VALUES	= {
					    "FLOW_CONTROL",
					    "REMOVE_OLDEST",
					    "REJECT_NEWEST",
					    "REMOVE_LOW_PRIORITY"
						};
    public static String LIMIT_BEHAV_FLOW_CONTROL = BKR_LIMIT_BEHAV_VALID_VALUES[0];
    public static String LIMIT_BEHAV_RM_OLDEST = BKR_LIMIT_BEHAV_VALID_VALUES[1];
    public static String LIMIT_BEHAV_REJECT_NEWEST = BKR_LIMIT_BEHAV_VALID_VALUES[2];
    public static String LIMIT_BEHAV_RM_LOW_PRIORITY = BKR_LIMIT_BEHAV_VALID_VALUES[3];
}
