/*
 * @(#)BrokerDestListCObj.java	1.12 05/02/10
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */

package com.sun.messaging.jmq.admin.apps.console;

import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import javax.swing.JMenuItem;

import com.sun.messaging.jmq.admin.bkrutil.BrokerAdmin;
import com.sun.messaging.jmq.admin.util.Globals;
import com.sun.messaging.jmq.admin.resources.AdminConsoleResources;

/** 
 * This class is used in the JMQ Administration console
 * to store information related to the broker destination
 * list.
 *
 * @see ConsoleObj
 * @see BrokerAdminCObj
 *
 */
public class BrokerDestListCObj extends BrokerAdminCObj  {

    private BrokerCObj bCObj;
    private static AdminConsoleResources acr = Globals.getAdminConsoleResources();

    public BrokerDestListCObj (BrokerCObj bCObj) {
	this.bCObj = bCObj;
    }

    public BrokerCObj getBrokerCObj() {
	return (bCObj);
    }

    public BrokerAdmin getBrokerAdmin() {
	return (bCObj.getBrokerAdmin());
    }

    public String getExplorerLabel()  {
	return (acr.getString(acr.I_BROKER_DEST_LIST));
    }

    public String getExplorerToolTip()  {
	return (null);
    }

    public ImageIcon getExplorerIcon()  {
	return (AGraphics.adminImages[AGraphics.BROKER_DEST_LIST]);
    }

    public String getActionLabel(int actionFlag, boolean forMenu)  {
	if (forMenu)  {
	    switch (actionFlag)  {
	    case ActionManager.ADD:
	        return (acr.getString(acr.I_MENU_ADD_BROKER_DEST));

	    case ActionManager.PAUSE:
	        return (acr.getString(acr.I_MENU_PAUSE_ALL_DESTS));

	    case ActionManager.RESUME:
	        return (acr.getString(acr.I_MENU_RESUME_ALL_DESTS));
	    }
	} else  {
	    switch (actionFlag)  {
	    case ActionManager.ADD:
	        return (acr.getString(acr.I_ADD_BROKER_DEST));

	    case ActionManager.PAUSE:
	        return (acr.getString(acr.I_PAUSE_ALL_DESTS));

	    case ActionManager.RESUME:
	        return (acr.getString(acr.I_RESUME_ALL_DESTS));
	    }
	}

	return (null);
    }

    public int getExplorerPopupMenuItemMask()  {
	return (ActionManager.ADD | ActionManager.PAUSE |
		ActionManager.RESUME);
    }


    public int getActiveActions()  {
	BrokerAdmin ba = getBrokerAdmin();
	int mask;
	if (ba.isConnected())
	    mask = ActionManager.ADD | ActionManager.REFRESH |
 		   ActionManager.PAUSE | ActionManager.RESUME;
	else
	    mask = 0;

	return (mask);
    }



    public String getInspectorPanelClassName()  {
	return (ConsoleUtils.getPackageName(this) + ".BrokerDestListInspector");
    }

    public String getInspectorPanelId()  {
	return ("Broker Destinations");
    }

    public String getInspectorPanelHeader()  {
	return (getInspectorPanelId());
    }
}
