/*
 * @(#)JMSXAConnectionFactory.java	1.2 01/11/30
 * Original @(#)JMSXAConnectionFactory.java	1.2 00/11/21
 *
 * Copyright 1997-2001 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the proprietary information of Sun Microsystems, Inc.  
 * Use is subject to license terms.
 * 
 */

package com.sun.jms.spi.xa;

/** Some application servers provide support for grouping JTS capable 
  * resource use into a distributed transaction (optional). To include JMS transactions
  * in a JTS transaction, an application server requires a JTS aware JMS 
  * provider. A JMS provider exposes its JTS support using a JMS 
  * JMSXAConnectionFactory which an application server uses to create XASessions.
  *
  * <P>JMSXAConnectionFactory's are JMS administered objects just like 
  * ConnectionFactory's. It is expected that application servers will find 
  * them using JNDI.
  *
  * @version     1.0 - 14 May 1998
  * @author      Mark Hapner
  * @author      Rich Burridge
  *
  * @see         com.sun.jms.spi.xa.JMSXAQueueConnectionFactory
  * @see         com.sun.jms.spi.xa.JMSXATopicConnectionFactory
  */

public interface JMSXAConnectionFactory {
}
