/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.jmq.jmsclient.ExceptionHandler;
import com.sun.messaging.jmq.jmsclient.MessageImpl;
import com.sun.messaging.jmq.jmsclient.Traceable;
import java.io.PrintStream;
import javax.jms.JMSException;
import javax.jms.TextMessage;

public class TextMessageImpl
extends MessageImpl
implements TextMessage,
Traceable {
    private String text = null;

    protected void setMessageBodyToPacket() throws JMSException {
        if (this.text == null) {
            return;
        }
        try {
            this.setMessageBody(this.text.getBytes("UTF8"));
        }
        catch (Exception exception) {
            ExceptionHandler.handleException(exception, "C4014");
        }
    }

    protected void getMessageBodyFromPacket() throws JMSException {
        try {
            byte[] byArray = this.getMessageBody();
            if (byArray != null) {
                this.text = new String(byArray, "UTF8");
            }
        }
        catch (Exception exception) {
            ExceptionHandler.handleException(exception, "C4015");
        }
    }

    protected TextMessageImpl() throws JMSException {
        this.setPacketType(1);
    }

    public void clearBody() throws JMSException {
        this.text = null;
        this.setMessageReadMode(false);
    }

    public void setText(String string) throws JMSException {
        this.checkMessageAccess();
        this.text = string;
    }

    public String getText() throws JMSException {
        return this.text;
    }

    public String toString() {
        return "\nText:\t" + this.text + super.toString();
    }

    public void dump(PrintStream printStream) {
        printStream.println("------ TextMessageImpl dump ------");
        super.dump(printStream);
    }
}

